<?php
    $addons = \Modules\Addons\Entities\Addon::find('reviews');
?>

<style>
    .review-template-v1-<?php echo e($component->id); ?> {
        --text-color-light: <?php echo e($component->text_color_light); ?>;
        --text-color-dark: <?php echo e($component->text_color_dark); ?>;

        --bg-color-light: <?php echo e($component->main_bg_color_light); ?>;
        --bg-color-dark: <?php echo e($component->main_bg_color_dark); ?>;
    }

    .review-template-bg-<?php echo e($component->id); ?> {
        background-image: url('<?php echo e(isset($component->main_bg_image_light) && !empty($component->main_bg_image_light) ? urlSlashReplace(pathToUrl($component->main_bg_image_light)) : ''); ?>');
        background-repeat: no-repeat, repeat;
        background-size: cover;
    }
    .dark .review-template-bg-<?php echo e($component->id); ?> {
        background-image: url('<?php echo e(isset($component->main_bg_image_dark) && !empty($component->main_bg_image_dark) ? urlSlashReplace(pathToUrl($component->main_bg_image_dark)) : ''); ?>');
        background-repeat: no-repeat, repeat;
        background-size: cover;
    }
</style>

<?php if($addons->isEnabled()): ?>
    <?php
        $userReviews = $homeService->getReviews($component->review_type, $component->review_limit, [], $component->reviews);
        $reviewLimit = $component->review_type == 'selectedReviews' ? count($component->reviews) : $component->review_limit;
        $textColor = empty($component->text_color_light) && empty($component->text_color_dark) ? 'text-color-14 dark:text-white' : 'text-[var(--text-color-light)] dark:text-[var(--text-color-dark)]';
        $bgColor =  empty($component->main_bg_color_light) && empty($component->main_bg_color_dark) ? '' : 'bg-[var(--bg-color-light)] dark:bg-[var(--bg-color-dark)]';
    ?>

    <?php echo do_action('handle_adsense_output_top',  $component); ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($userReviews) > 0): ?>
        <div class="9xl:!px-[310px] 8xl:!px-40 lg:!px-16 md:!px-10 px-5 py-[75px] review-template-v1-<?php echo e($component->id); ?>

            <?php echo e($component->background_type == 'backgroundImage' ? 'review-template-bg-' . $component->id : $bgColor); ?>" 
            style="padding:<?php echo e(!empty($component->pt_y) ? $component->pt_y . ' ' . '0' : ''); ?>;">
            <div class="relative flex justify-center items-center">
                <p class="uppercase absolute heading-1 tracking-[0.2em] text-center font-bold text-16 font-Figtree">
                    <?php echo strtoupper($component->overline); ?>

                </p>
            </div>
            <p class="mt-[18px] font-RedHat 6xl:text-48 text-36 font-bold text-center break-words px-5 <?php echo e($textColor); ?>">
                <?php echo $component->heading; ?>

            </p>
            <p class="mt-3 font-Figtree font-normal text-center 6xl:text-18 text-16 <?php echo e($textColor); ?>">
                <?php echo $component->body; ?>

            </p>
            
            <div class="6xl:mt-16 mt-8">
                <div class="grid md:grid-cols-2 2xl:grid-cols-4 grid-cols-1 gap-6">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 0; $i < $reviewLimit; $i++): ?>
                        <div class="dark:bg-color-29 skeleton-loader p-5 rounded-[20px] relative h-[250px]">
                            
                        </div>
                    <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <button class="has-ajax-load-data opacity-0 invisible" onclick="ajaxProductLoad(this)" data-component="<?php echo e($component->id); ?>"></button>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php echo do_action('handle_adsense_output_bottom',  $component); ?>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/templates/blocks/review-template-v1.blade.php ENDPATH**/ ?>