
<?php $__env->startSection('page_title', __('Subscription Setting')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="account-settings-container">
        <div class="card">
            <div class="card-body row">
                <div class="col-12 ps-0">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5><?php echo e(__('Subscription Settings')); ?></h5>
                        </div>
                        <div class="card-block table-border-style">
                            <form action="<?php echo e(route('package.subscription.setting')); ?>" method="post" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <div class="card-body p-0">
                                    <div class="form-group row">
                                        <label class="col-4 control-label" for="subscription_downgrade"><?php echo e(__('Downgrade')); ?></label>
                                        <div class="col-6">
                                            <input type="hidden" value="0" name="subscription_downgrade">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input type="checkbox" <?php if(old('subscription_downgrade', preference('subscription_downgrade'))): echo 'checked'; endif; ?> value="1" name="subscription_downgrade" id="subscription_downgrade">
                                                <label for="subscription_downgrade" class="cr"></label>
                                            </div>
                                            <label class="mt-1"><?php echo e(__('Allow subscription downgrade')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-4 control-label" for="subscription_change_plan"><?php echo e(__('Change Plan')); ?></label>
                                        <div class="col-6">
                                            <input type="hidden" value="0" name="subscription_change_plan">
                                            <div class="switch switch-bg d-inline m-r-10 edit-is_default">
                                                <input type="checkbox" <?php if(old('subscription_change_plan', preference('subscription_change_plan'))): echo 'checked'; endif; ?> value="1" name="subscription_change_plan" id="subscription_change_plan">
                                                <label for="subscription_change_plan" class="cr"></label>
                                            </div>
                                            <label class="mt-1"><?php echo e(__('Allow change plan one to another')); ?></label>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-4 control-label" for="customer_default_signup_status"><?php echo e(__('Subscription Renewal')); ?></label>
                                        <div class="col-6">
                                            <select name="subscription_renewal" class="form-control select2-hide-search" >
                                                <option <?php if(old('subscription_renewal', preference('subscription_renewal')) == 'automate'): echo 'selected'; endif; ?> value="automate"><?php echo e(__('Automate')); ?></option>
                                                <option <?php if(old('subscription_renewal', preference('subscription_renewal')) == 'manual'): echo 'selected'; endif; ?> value="manual"><?php echo e(__('Manual')); ?></option>
                                                <option <?php if(old('subscription_renewal', preference('subscription_renewal')) == 'customer_choice'): echo 'selected'; endif; ?> value="customer_choice"><?php echo e(__('Customer Choice')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label class="col-4 control-label"><?php echo e(__('Balance Priority')); ?></label>
                                        <div class="col-6">
                                            <select name="credit_balance_priority" class="form-control select2-hide-search" >
                                                <option <?php if(old('credit_balance_priority', preference('credit_balance_priority')) == 'subscription'): echo 'selected'; endif; ?> value="subscription"><?php echo e(__('Subscription')); ?></option>
                                                <option <?php if(old('credit_balance_priority', preference('credit_balance_priority')) == 'onetime'): echo 'selected'; endif; ?> value="onetime"><?php echo e(__('Onetime')); ?></option>
                                            </select>
                                            <label class="mt-1"><span class="badge badge-info"><?php echo e(__('Note')); ?></span> <?php echo e(__('The balance priority indicate whether the subscription credit balance or the one-time credit balance is deducted first if both are available.')); ?></label>
                                        </div>
                                    </div>

                                    <div class="card-footer p-0">
                                        <div class="form-group row">
                                            <label for="btn_save" class="col-sm-3 control-label"></label>
                                            <div class="col-sm-12">
                                                <button type="submit" class="btn form-submit custom-btn-submit float-right" id="footer-btn">
                                                    <?php echo e(__('Save')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/Subscription/Resources/views/configuration.blade.php ENDPATH**/ ?>