
<?php $__env->startSection('page_title', __('User Profile')); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/lightbox/css/lightbox.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/media-manager.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-sm-12" id="user-edit-container">
        <div class="card">
            <div class="card-header">
                <h5><a href="<?php echo e(route('users.index')); ?>"><?php echo e(__('Users')); ?></a> >> <?php echo e($user->name); ?> >>
                    <?php echo e(__('Profile')); ?></h5>
            </div>
            <div class="card-body p-0" id="no_shadow_on_card">
                <div class="col-sm-12 m-t-20 form-tabs">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link font-bold active text-uppercase" id="user-info-tab" data-bs-toggle="tab"
                                href="#user-info" role="tab" aria-controls="user-info-tab"
                                aria-selected="true"><?php echo e(__(':x Information', ['x' => __('User')])); ?></a>
                        </li>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array('App\Http\Controllers\UserController@updatePassword', $prms)): ?>
                            <li class="nav-item">
                                <a class="nav-link font-bold text-uppercase" id="password-tab" data-bs-toggle="tab"
                                    data-rel="<?php echo e($user->id); ?>" href="#password" role="tab"
                                    aria-controls="password-tab" aria-selected="false"><?php echo e(__('Update Password')); ?></a>
                            </li>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </ul>
                    <div class="col-sm-12 tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="user-info" role="tabpanel"
                            aria-labelledby="user-info-tab">
                            <form action='<?php echo e(route('users.updateProfile', ['id' => Auth::user()->id])); ?>' method="post"
                                class="form-horizontal" id="userEdit" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-sm-8">
                                        <div class="form-group row">
                                            <label for="first_name"
                                                class="col-sm-2 col-form-label require pr-0"><?php echo e(__('Name')); ?>

                                            </label>
                                            <div class="col-sm-10">
                                                <input type="text" placeholder="<?php echo e(__('Name')); ?>"
                                                    class="form-control inputFieldDesign" id="name" name="name"
                                                    required minlength="3"
                                                    value="<?php echo e(!empty(old('name')) ? old('name') : $user->name); ?>"
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-min-length="<?php echo e(__(':x should contain at least :y characters.', ['x' => __('Name'), 'y' => 3])); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email"
                                                class="col-sm-2 col-form-label require"><?php echo e(__('Email')); ?></label>
                                            <div class="col-sm-10">
                                                <input type="email" class="form-control inputFieldDesign" id="email"
                                                    name="email"
                                                    value="<?php echo e(!empty(old('email')) ? old('email') : (config('openAI.is_demo') ? 'xxxxxxx@xx.xx' : $user->email)); ?>"
                                                    placeholder="<?php echo e(__('Email')); ?>" required
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-type-mismatch="<?php echo e(__('Enter a valid :x.', ['x' => strtolower(__('Email'))])); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="role_id"
                                                class="col-sm-2 control-label"><?php echo e(__('Role')); ?></label>
                                            <div class="col-sm-10">
                                                <select class="form-control select2-hide-search inputFieldDesign" disabled
                                                    name="role_ids[]" id="role_id">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($role->id); ?>"
                                                            <?php echo e(in_array($role->id, $roleIds) ? 'selected' : ''); ?>>
                                                            <?php echo e($role->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="Status"
                                                class="col-sm-2 col-form-label require"><?php echo e(__('Status')); ?></label>
                                            <div class="col-sm-10">
                                                <select class="form-control select2-hide-search inputFieldDesign" disabled
                                                    name="status" id="status">
                                                    <option value="Pending"
                                                        <?php echo e(old('status', $user->status) == 'Pending' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Pending')); ?></option>
                                                    <option value="Active"
                                                        <?php echo e(old('status', $user->status) == 'Active' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Active')); ?></option>
                                                    <option value="Inactive"
                                                        <?php echo e(old('status', $user->status) == 'Inactive' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Inactive')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="designation"
                                                class="col-sm-2 col-form-label pr-0"><?php echo e(__('Designation')); ?>

                                            </label>
                                            <div class="col-sm-10">
                                                <input type="text" placeholder="<?php echo e(__('Designation')); ?>"
                                                    class="form-control inputFieldDesign" id="designation"
                                                    name="designation"
                                                    value="<?php echo e(!empty(old('designation')) ? old('designation') : $user->designation); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="description"
                                                class="col-sm-2 col-form-label pr-0"><?php echo e(__('Description')); ?>

                                            </label>
                                            <div class="col-sm-10 editor">
                                                <textarea class="form-control" name="description" id="description"><?php echo e(!empty(old('description')) ? old('description') : $user->description); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="facebook"
                                                class="col-sm-2 col-form-label pr-0"><?php echo e(__('facebook')); ?>

                                            </label>
                                            <div class="col-sm-10">
                                                <input type="url" placeholder="https://www.facebook.com"
                                                    class="form-control inputFieldDesign" id="facebook" name="facebook"
                                                    value="<?php echo e(!empty(old('facebook')) ? old('facebook') : $user->facebook); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="twitter"
                                                class="col-sm-2 col-form-label pr-0"><?php echo e(__('twitter')); ?>

                                            </label>
                                            <div class="col-sm-10">
                                                <input type="url" placeholder="https://www.twitter.com"
                                                    class="form-control inputFieldDesign" id="twitter" name="twitter"
                                                    value="<?php echo e(!empty(old('twitter')) ? old('twitter') : $user->twitter); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="instagram"
                                                class="col-sm-2 col-form-label pr-0"><?php echo e(__('Instagram')); ?>

                                            </label>
                                            <div class="col-sm-10">
                                                <input type="url" placeholder="https://www.instagram.com"
                                                    class="form-control inputFieldDesign" id="instagram" name="instagram"
                                                    value="<?php echo e(!empty(old('instagram')) ? old('instagram') : $user->instagram); ?>">
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label pr-0"><?php echo e(__('Picture')); ?></label>
                                            <div class="col-sm-10">
                                                <div class="custom-file" data-val="single" id="image-status"
                                                    data-type='<?php echo e(implode(',', getFileExtensions(2))); ?>'>
                                                    <input class="form-control up-images attachment d-none inputFieldDesign"
                                                        name="attachment" id="validatedCustomFile" accept="image/*">
                                                    <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                        for="validatedCustomFile"><?php echo e(__('Upload image')); ?></label>
                                                </div>
                                                <div id="img-container">
                                                    <div class="d-flex flex-wrap mt-2">
                                                        <div
                                                            class="position-relative border boder-1 p-1 mr-2 rounded mt-2">
                                                            <div
                                                                class="position-absolute rounded-circle text-center img-remove-icon">
                                                                <i class="fa fa-times"></i>
                                                            </div>
                                                            <img class="upl-img" class="p-1"
                                                                src="<?php echo e($user->fileUrl()); ?>" alt="<?php echo e(__('Image')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row" id="divNote">
                                            <label class="col-sm-2 control-label"></label>
                                            <div class="col-sm-10" id='note_txt_1'>
                                                <span class="badge badge-danger"><?php echo e(__('Note')); ?>!</span>
                                                <?php echo e(__('Allowed File Extensions: jpg, png, gif, bmp')); ?>

                                            </div>
                                            <div class="col-md-9" id='note_txt_2'>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-10 px-0 m-l-5">
                                    <a href="<?php echo e(route('users.index')); ?>"
                                        class="btn custom-btn-cancel all-cancel-btn"><?php echo e(__('Cancel')); ?></a>
                                    <button class="btn custom-btn-submit" type="submit"
                                        id="btnSubmit"><?php echo e(__('Update')); ?></button>
                                </div>
                            </form>
                        </div>

                        <div class="tab-pane fade" id="password" role="tabpanel" aria-labelledby="password-tab">
                            <div class="row">
                                <div class="col-sm-12">
                                    <form action='<?php echo e(route('users.profilePassword', ['id' => $user->id])); ?>'
                                        class="form-horizontal" id="password-form" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="password"
                                                class="col-sm-2 text-left col-form-label require"><?php echo e(__('Password')); ?></label>
                                            <div class="col-sm-6">
                                                <input type="password" class="form-control inputFieldDesign"
                                                    id="password" name="password" placeholder="<?php echo e(__('Password')); ?>"
                                                    value="<?php echo e(old('password')); ?>" required minlength="5"
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-min-length="<?php echo e(__(':x should contain at least :y characters.', ['x' => __('Password'), 'y' => 5])); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-1">
                                            <label for="password"
                                                class="col-sm-2 text-left col-form-label require"><?php echo e(__('Confirm Password')); ?></label>
                                            <div class="col-sm-6">
                                                <input type="password" class="form-control inputFieldDesign"
                                                    id="confirm_password" name="confirm_password"
                                                    placeholder="<?php echo e(__('Confirm Password')); ?>"
                                                    value="<?php echo e(old('confirm_password')); ?>" required minlength="5"
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-sm-2 control-label"></label>
                                            <div class="col-sm-10">
                                                <div class="checkbox checkbox-primary checkbox-fill d-inline">
                                                    <input type="checkbox" class="form-control inputFieldDesign"
                                                        name="send_mail" id="checkbox-p-fill-1">
                                                    <label for="checkbox-p-fill-1"
                                                        class="cr"><?php echo e(__('Send email to the user')); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-10 px-0 m-l-5">
                                            <button class="btn custom-btn-submit all-cancel-btn" type="submit"
                                                id="btnSubmit1"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/plugins/lightbox/js/lightbox.min.js')); ?>"></script>

    <script type="text/javascript">
        "use strict";
        var user_id = '<?php echo e($user->id); ?>';
    </script>
    <script src="<?php echo e(asset('public/dist/js/custom/user.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/resources/views/admin/users/profile.blade.php ENDPATH**/ ?>