<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(languageDirection()); ?>" class="<?php echo e(\Illuminate\Support\Facades\Cookie::get('theme_preference')); ?>">



<?php
$favicon = App\Models\Preference::getFavicon();
?>

<head>
    <title><?php echo e(trimWords(preference('company_name'), 17)); ?> | <?php echo $__env->yieldContent('page_title', env('APP_NAME', '')); ?></title>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($favicon)): ?>
    <link rel='shortcut icon' href="<?php echo e($favicon); ?>" type='image/x-icon' />
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php echo $__env->yieldContent('child-head'); ?>

    <!-- Required CSS -->

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/chat/css/chat-widget.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/plugin/jquery-ui/jquery-ui.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/plugin/jquery-ui/jquery-ui-theme.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/plugin/Magnific-Popup/magnific-popup.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/common/tailwind-custom.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/tailwind/css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/site_custom.min.css')); ?>">
    

    <?php echo $__env->yieldContent('child-css'); ?>

    <!-- User define custom dynamic css file -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(File::exists('Modules/CMS/Resources/assets/css/user-custom.css')): ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules/CMS/Resources/assets/css/user-custom.css?v=' . time())); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</head>

<body class="flex flex-col justify-between">
    
<div class="fixed top-3 right-0 left-0 text-center z-[9999999]">
    <?php echo $__env->make('partials.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 </div>
    <?php echo $__env->yieldContent('child-content'); ?>

    <!-- Required JS -->
    <script>
        'use strict';

        var SITE_URL = "<?php echo e(url('/')); ?>";
        var CSRF_TOKEN = "<?php echo e(csrf_token()); ?>";
        var loginNeeded = false;
        const SWITCH_THEME_URL = "<?php echo e(route('theme.switch')); ?>";
        var themePreference = "<?php echo e(Cookie::get('theme_preference')); ?>";
        var txLnSts = <?php echo $json; ?>;
        var ACCESS_TOKEN = "<?php echo e(!empty($accessToken) ? $accessToken : ''); ?>";
        const is_demo = "<?php echo config('openAI.is_demo'); ?>";
        const open_ai = <?php echo json_encode(config('openAI'), 15, 512) ?>;
        const user_ip = "<?php echo e(str_replace('.', '_', getIpAddress())); ?>";
    </script>
    
    <script src="<?php echo e(asset('public/assets/plugin/jquery-ui/jquery-3.6.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/plugin/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/slim.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/plugin/Magnific-Popup/magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/plugin/Magnific-Popup/magnific-modal.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/js/sweet-alert2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/chat/js/chat.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/plugin/tailwind-components/tailwind-component.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/login.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/shared/theme-preference.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/lang.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/package_switch.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/xss.min.js')); ?>"></script>

    <?php echo $__env->yieldContent('child-js'); ?>

    <?php if ($__env->exists('gdpr::widget')) echo $__env->make('gdpr::widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- User define custom dynamic js file -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(File::exists('Modules/CMS/Resources/assets/css/user-custom.js')): ?>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/user-custom.js?v=' . time())); ?>"></script>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</body>

</html>

<?php /**PATH /home/consuadmin/public_html/resources/views/layouts/master.blade.php ENDPATH**/ ?>