<?php
    $component = isset($component) ? $component : null;
    $allFaqs = \Modules\CMS\Service\Homepage::getFaqList();
    $rand = uniqid();
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline"
                        value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading"
                        value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Body')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body"> <?php echo e($component ? $component->body : ''); ?></textarea>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__(':x Type', ['x' => 'FAQ'])); ?></dt>
                </label>
                <div class="col-sm-8">
                    <select type="text" class="form-control crequired select3 faq_type" name="faq_type">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \Modules\CMS\Service\Homepage::faqsOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($component && $component->faq_type == $key ? 'selected' : ''); ?>

                                value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
            </div>
            <div
                class="form-group row cats selectedFaqs <?php echo e($component && $component->faq_type == 'selectedFaqs' ? '' : 'd-none'); ?>">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Faqs')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <select type="text" class="form-control select2 sl_common_bx select_faq" <?php echo e($component && $component->faq_type == 'selectedFaqs' ? 'required' : ''); ?> name="faqs[]" multiple>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && is_array($component->faqs)): ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $component->faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($allFaqs[$selected])): ?>
                                    <Option selected value="<?php echo e($selected); ?>"><?php echo e($allFaqs[$selected]); ?>

                                    </Option>
                                    <?php
                                        unset($allFaqs[$selected]);
                                    ?>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <Option value="<?php echo e($key); ?>"><?php echo e($value); ?></Option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="form-group row cats latestFaqs <?php echo e(empty($component->faq_type) || $component->faq_type == 'latestFaqs' ? '' : 'd-none'); ?>">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('No. of :x to show', ['x' => 'FAQ'])); ?></dt>
                </label>
                <div class="col-sm-8">
                    <div>
                        <input type="number" min="1" class="form-control crequired inputFieldDesign faq_limit" name="faq_limit"
                        <?php echo e(empty($component->faq_type) || $component->faq_type == 'latestFaqs' ? 'required' : ''); ?>

                        value="<?php echo e($component ? $component->faq_limit : 8); ?>" data-min="<?php echo e(__('The value must be :x than or equal to :y', ['x' => __('greater'), 'y' => 1])); ?>">
                    </div>
                    
                    <div class="d-flex mt-2">
                        <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                        <small
                            class="mt-1 ltr:ms-2 rtl:me-2 px-2"><?php echo e(__('Total :x to display should range from 1 to as per your preference, with the default set at 8.', ['x' => 'faqs'])); ?></small>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['padding-vertical']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>

<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/faq-template-v1.blade.php ENDPATH**/ ?>