@extends('layouts.user_master')
@section('page_title', __('Dashboard'))

@section('css')
<link rel="stylesheet" href="{{ asset('public/assets/css/user/dashboard.css') }}?v={{ time() }}">
@endsection

@section('content')
{{-- main content --}}
<main class="w-[68.9%] 5xl:w-[85.9%] lg:pt-[88px] pt-20 9xl:px-[245px] 7xl:px-[135px] 5xl:px-[67px] px-5 pb-28 overflow-auto main-content flex flex-col flex-1 font-Figtree bg-color-F6 dark:bg-[#292929] border-l dark:border-[#474746] border-color-DF h-screen custom-scrollbar">
    
    {{-- Header Section --}}
    <div class="animate-fade-in">
        <p class="tracking-[0.2em] uppercase text-color-14 dark:text-white font-normal text-[13px] leading-5 font-Figtree">
            {{ __('Welcome to :x', ['x' => preference('company_name')]) }}</p>
        <p class="text-color-14 dark:text-white font-bold text-[26px] leading-[34px] font-RedHat mt-2">
            {{ __('Unleash the power of Artificial Intelligence') }}</p>
    </div>

    {{-- ============================================
         STATISTICS CARDS - Matching System Design
         ============================================ --}}
    <div class="lg:mt-6 mt-5 grid 3xl:grid-cols-4 lg:grid-cols-2 grid-cols-1 md:gap-4 gap-3 w-full">
        {{-- Documents Card --}}
        <a class="stat-card-enhanced bg-white dark:bg-color-3A rounded-xl 6xl:py-[26px] lg:py-5 py-4 6xl:px-5 lg:px-3 px-5 border border-color-DF dark:border-color-47 hover:border-purple-500 dark:hover:border-purple-500 transition-all duration-300 animate-fade-in delay-1" 
           href="{{ route('user.documents') }}">
            <div class="flex justify-between items-start gap-3">
                <div class="flex-1">
                    <div class="flex items-center gap-2 mb-2">
                        <div class="w-9 h-9 rounded-lg bg-gradient-to-br from-purple-100 to-pink-100 dark:from-purple-900/30 dark:to-pink-900/30 flex items-center justify-center">
                            <svg class="w-5 h-5 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                    </div>
                    <p class="text-color-14 dark:text-white text-[13px] leading-5 font-normal font-Figtree">
                        {{ __('Number of') }}</p>
                    <p class="text-color-14 dark:text-white font-semibold leading-6 font-Figtree text-[16px] mt-1 break-all">
                        {{ __('Documents Made') }}</p>
                </div>
                <p class="text-gradient-1 text-[28px] leading-9 font-RedHat font-bold">{{ $totalDocument }}</p>
            </div>
        </a>

        {{-- Images Card --}}
        <a class="stat-card-enhanced bg-white dark:bg-color-3A rounded-xl 6xl:py-[26px] lg:py-5 py-4 6xl:px-5 lg:px-3 px-5 border border-color-DF dark:border-color-47 hover:border-purple-500 dark:hover:border-purple-500 transition-all duration-300 3xl:order-none lg:order-4 animate-fade-in delay-2" 
           href="{{ route('user.image.index') }}">
            <div class="flex justify-between items-start gap-3">
                <div class="flex-1">
                    <div class="flex items-center gap-2 mb-2">
                        <div class="w-9 h-9 rounded-lg bg-gradient-to-br from-indigo-100 to-blue-100 dark:from-indigo-900/30 dark:to-blue-900/30 flex items-center justify-center">
                            <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                    </div>
                    <p class="text-color-14 dark:text-white text-[13px] leading-5 font-normal font-Figtree">
                        {{ __('Amount of') }}</p>
                    <p class="text-color-14 dark:text-white font-semibold leading-6 font-Figtree text-[16px] mt-1 break-all">
                        {{ __('Images Created') }}</p>
                </div>
                <p class="text-gradient-1 text-[28px] leading-9 font-RedHat font-bold">{{ $totalImage }}</p>
            </div>
        </a>

        {{-- Videos Card (Replaces Codes Written) --}}
        <a class="stat-card-enhanced bg-white dark:bg-color-3A rounded-xl 6xl:py-[26px] lg:py-5 py-4 6xl:px-5 lg:px-3 px-5 border border-color-DF dark:border-color-47 hover:border-purple-500 dark:hover:border-purple-500 transition-all duration-300 3xl:order-none lg:order-3 animate-fade-in delay-3" 
           href="{{ route('user.text-to-video.template') }}">
            <div class="flex justify-between items-start gap-3">
                <div class="flex-1">
                    <div class="flex items-center gap-2 mb-2">
                        <div class="w-9 h-9 rounded-lg bg-gradient-to-br from-rose-100 to-orange-100 dark:from-rose-900/30 dark:to-orange-900/30 flex items-center justify-center">
                            <svg class="w-5 h-5 text-rose-600 dark:text-rose-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                        </div>
                    </div>
                    <p class="text-color-14 dark:text-white text-[13px] leading-5 font-normal font-Figtree">
                        {{ __('Amount of') }}</p>
                    <p class="text-color-14 dark:text-white font-semibold leading-6 font-Figtree text-[16px] mt-1 break-all">
                        {{ __('Videos Created') }}</p>
                </div>
                <p class="text-gradient-1 text-[28px] leading-9 font-RedHat font-bold">{{ $totalVideo ?? 0 }}</p>
            </div>
        </a>

        {{-- Chat with AI Card --}}
        <div class="magic-bg rounded-xl lg:py-[25px] py-10 6xl:px-5 px-3 flex justify-between items-center relative 3xl:order-none lg:order-2 mt-14 lg:mt-0 dashboard-robo animate-fade-in delay-4">
            <div>
                <p class="text-white text-[12px] leading-[18px] font-medium font-Figtree tracking-[0.2em] uppercase 3xl:w-[130px]">
                    {{ __("LET'S TALK") }}</p>
                <a href="{{ route('chat.index') }}"
                    class="dashboard-chat text-white mt-1.5 font-semibold text-[18px] 3xl:w-[130px] 9xl:w-[130px] 7xl:w-[110px] font-Figtree justify-start gap-2.5 items-center inline-block group">
                    <span>{{ __('Chat with AI') }}</span>
                    <span class="w-3 h-3 inline-block ml-2.5 transition-transform group-hover:translate-x-1">
                        <svg class="w-3 h-3" xmlns="http://www.w3.org/2000/svg" width="11" height="10" viewBox="0 0 11 10" fill="none">
                            <path d="M10.7698 5.52948C11.0767 5.23663 11.0767 4.76103 10.7698 4.46818L6.84101 0.719641C6.53407 0.426786 6.0356 0.426786 5.72867 0.719641C5.42173 1.0125 5.42173 1.48809 5.72867 1.78094L8.31921 4.25029H0.785758C0.351136 4.25029 0 4.58532 0 5C0 5.41468 0.351136 5.74971 0.785758 5.74971H8.31676L5.73112 8.21905C5.42419 8.51191 5.42419 8.9875 5.73112 9.28036C6.03806 9.57321 6.53653 9.57321 6.84346 9.28036L10.7723 5.53182L10.7698 5.52948Z" fill="white" />
                        </svg>
                    </span>
                </a>
            </div>
            <img class="bottom-0 absolute right-0 3xl:w-[108px] 7xl:w-[137px] transition-transform hover:scale-105" src="{{ asset('public/assets/image/dashboard-robo.png') }}" alt="{{ __('Image') }}">
        </div>
    </div>

    {{-- Coupons Section --}}
    @if(count($coupons) > 0)

    <div class="lg:mt-6 mt-5 animate-on-scroll">
        <div class="flex items-center justify-between mb-4">
            <p class="text-[18px] font-medium font-Figtree leading-[26px] text-color-14 dark:text-white">
                {{ __('Special Offers') }}</p>
        </div>
        <div class="grid 3xl:grid-cols-4 lg:grid-cols-2 grid-cols-1 md:gap-4 gap-3 w-full">
            @foreach ($coupons as $coupon)
            <div class="coupon-card-enhanced bg-white dark:bg-color-3A rounded-xl overflow-hidden border border-color-DF dark:border-color-47 hover:border-transparent transition-all duration-300">
                {{-- Coupon Header with Discount --}}
                <div class="coupon-header p-5 pb-4 relative">
                    <div class="flex items-start justify-between">
                        <div>
                            <div class="flex items-baseline gap-1">
                                <span class="text-[36px] font-bold font-RedHat text-gradient-1 leading-none">{{ round($coupon->discount_amount) }}{{ $coupon->discount_type == 'Percentage' ? '%' : '' }}</span>
                                <span class="text-[14px] font-semibold text-color-89 dark:text-color-DF uppercase">{{ __("Off") }}</span>
                            </div>
                            <p class="mt-2 font-Figtree font-semibold text-color-14 dark:text-white text-[15px] leading-[22px]">
                                {{ $coupon->name }}</p>
                        </div>
                        {{-- Decorative badge --}}
                        <div class="coupon-badge w-10 h-10 rounded-full bg-gradient-to-br from-purple-100 to-pink-100 dark:from-purple-900/30 dark:to-pink-900/30 flex items-center justify-center flex-shrink-0">
                            <svg class="w-5 h-5 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                {{-- Coupon Code Section --}}
                <div class="px-5 pb-4">
                    <div class="coupon-code-box flex items-center justify-between gap-2 p-2.5 rounded-lg bg-color-F6 dark:bg-[#292929] border-2 border-dashed border-color-DF dark:border-color-47">
                        <div class="flex items-center gap-2 min-w-0 flex-1">
                            <svg class="w-4 h-4 text-purple-600 dark:text-purple-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                            <span class="font-mono font-bold text-[13px] text-color-14 dark:text-white truncate">{{ $coupon->code }}</span>
                            <span class="hidden" data-coupon-code>{{ $coupon->code }}</span>
                        </div>
                        <button type="button" class="copy-button coupon-copy-btn flex items-center gap-1.5 px-3 py-2 rounded-md text-white text-[12px] font-semibold transition-all flex-shrink-0 relative">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                            <span>{{ __("Copy") }}</span>
                            <span class="copied-message copy-success-msg absolute -top-9 left-1/2 -translate-x-1/2 bg-green-600 text-white text-[11px] font-medium px-3 py-1.5 rounded-md shadow-lg hidden whitespace-nowrap z-10">
                                <svg class="w-3 h-3 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                                {{ __('Copied!') }}
                            </span>
                        </button>
                    </div>
                </div>
                
                {{-- Coupon Details --}}
                <div class="coupon-details px-5 pb-5">
                    <div class="space-y-2">
                        {{-- Valid Date --}}
                        <div class="flex items-center gap-2 text-[12px] text-color-89 dark:text-color-DF">
                            <svg class="w-3.5 h-3.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            <span>{{ formatDate($coupon->start_date) }} - {{ formatDate($coupon->end_date) }}</span>
                        </div>
                        
                        {{-- Plans --}}
                        <div class="flex items-center gap-2 text-[12px] text-color-89 dark:text-color-DF">
                            <svg class="w-3.5 h-3.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                            <span>
                                @php
                                    $plansCount = isset($coupon->plans) ? $coupon->plans->count() : 0;
                                @endphp
                                @if ($plansCount > 0)
                                    {{ implode(', ', $coupon->plans->pluck('name')->take(2)->all()) }}{{ $plansCount > 2 ? ' +' . ($plansCount - 2) : '' }}
                                @else
                                    {{ __('All plans') }}
                                @endif
                            </span>
                        </div>
                        
                        {{-- Usage Limit --}}
                        @if ($coupon->usage_limit_per_user || $coupon->minimum_spend)
                        <div class="flex items-center gap-2 text-[12px] text-color-89 dark:text-color-DF">
                            <svg class="w-3.5 h-3.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <span>
                                @if ($coupon->usage_limit_per_user)
                                    {{ __('Max :x use(s)', ['x' => $coupon->usage_limit_per_user]) }}
                                @endif
                                @if ($coupon->usage_limit_per_user && $coupon->minimum_spend && $coupon->minimum_spend > 0)
                                    •
                                @endif
                                @if ($coupon->minimum_spend && $coupon->minimum_spend > 0)
                                    {{ __('Min :x', ['x' => formatNumber($coupon->minimum_spend)]) }}
                                @endif
                            </span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    {{-- ============================================
         ANALYTICS SECTION (Enhanced Chart)
         ============================================ --}}
    @php
    $currcentPackage = session()->get('memberPackageData');
    if (isset($currcentPackage)) {
        $sessionUserId = $currcentPackage['packageUser'];
    } else {
        $sessionUserId = auth()->user()->id;
    }
    @endphp

    <div class="sm:mt-7 mt-6 flex lg:flex-row flex-col justify-between gap-5 animate-on-scroll">
        {{-- Chart Container --}}
        <div class="chart-card rounded-xl bg-white dark:bg-color-3A p-5 w-full relative {{$subscription != NULL && auth()->user()->id == $sessionUserId ? ' 2xl:w-[72%] xl:w-[64%] w-full' : 'w-full'}}">
            {{-- Chart Header --}}
            <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 mb-4">
                <div>
                    <p class="text-[18px] leading-[26px] text-color-14 dark:text-white font-RedHat font-bold">
                        {{ __('Usage Statistics') }}</p>
                    <p class="text-color-89 dark:text-color-DF font-Figtree text-[12px] leading-[18px] font-medium mt-0.5">{{ $currentMonth }}</p>
                </div>
                {{-- Range Buttons --}}
                <div class="chart-range-group inline-flex p-1 bg-color-F3 dark:bg-color-47 rounded-lg">
                    <button type="button" class="chart-range-btn px-3 py-1.5 text-[12px] font-semibold rounded-md text-color-89 dark:text-color-DF transition-all" data-range="7d">{{ __('7D') }}</button>
                    <button type="button" class="chart-range-btn active px-3 py-1.5 text-[12px] font-semibold rounded-md transition-all" data-range="30d">{{ __('30D') }}</button>
                    <button type="button" class="chart-range-btn px-3 py-1.5 text-[12px] font-semibold rounded-md text-color-89 dark:text-color-DF transition-all" data-range="all">{{ __('All') }}</button>
                </div>
            </div>
            
            {{-- Compact Legend --}}
            <div class="flex flex-wrap items-center gap-x-5 gap-y-2 mb-4 pb-3 border-b border-color-DF dark:border-color-47">
                <button type="button" class="chart-legend-btn active" data-dataset="Documents">
                    <span class="legend-indicator legend-color-documents"></span>
                    <span>{{ __('Documents') }}</span>
                </button>
                <button type="button" class="chart-legend-btn active" data-dataset="Images">
                    <span class="legend-indicator legend-color-images"></span>
                    <span>{{ __('Images') }}</span>
                </button>
                <button type="button" class="chart-legend-btn active" data-dataset="Videos">
                    <span class="legend-indicator legend-color-videos"></span>
                    <span>{{ __('Videos') }}</span>
                </button>
                <button type="button" class="chart-legend-btn active" data-dataset="Codes">
                    <span class="legend-indicator legend-color-codes"></span>
                    <span>{{ __('Codes') }}</span>
                </button>
                <button type="button" class="chart-legend-btn active" data-dataset="Chats">
                    <span class="legend-indicator legend-color-chats"></span>
                    <span>{{ __('Chats') }}</span>
                </button>
            </div>

            {{-- Chart Canvas with Empty State --}}
            <div class="h-[300px] relative">
                @php
                    // Check if there's any data
                    $hasData = false;
                    $reports = [$documentReport, $imageReport, ($videoReport ?? '[]'), $codeReport, $chatReport];
                    foreach($reports as $report) {
                        $data = json_decode($report, true);
                        if (is_array($data) && array_sum($data) > 0) {
                            $hasData = true;
                            break;
                        }
                    }
                @endphp
                
                @if($hasData)
                    <canvas id="myChart" class="!w-full !h-full"></canvas>
                @else
                    {{-- Empty State --}}
                    <div class="absolute inset-0 flex flex-col items-center justify-center text-center p-8">
                        <div class="w-24 h-24 mx-auto mb-5 rounded-2xl bg-gradient-to-br from-purple-100 to-pink-100 dark:from-purple-900/30 dark:to-pink-900/30 flex items-center justify-center">
                            <svg class="w-12 h-12 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                        </div>
                        <h3 class="text-color-14 dark:text-white text-[18px] font-bold font-Figtree mb-2">
                            {{ __('No Usage Data Yet') }}
                        </h3>
                        <p class="text-color-89 dark:text-color-DF text-[14px] font-Figtree mb-6 max-w-[350px]">
                            {{ __('Start creating documents, images, or chat with AI to see your usage statistics here') }}
                        </p>
                    </div>
                @endif
            </div>

            {{-- Hidden data element for JS --}}
            <div id="dashboard-chart-data" class="hidden"
                data-dates="{{ $dates }}"
                data-documents="{{ $documentReport }}"
                data-images="{{ $imageReport }}"
                data-codes="{{ $codeReport }}"
                data-videos="{{ $videoReport ?? '[]' }}"
                data-chats="{{ $chatReport }}">
            </div>
        </div>

        {{-- Subscription Card --}}
        @if($subscription != NULL)
            @if (auth()->user()->id == $sessionUserId)
            <div class="relative bg-color-14 lg:h-full h-max rounded-xl {{$subscription != NULL ? '2xl:w-[28%] xl:w-[36%] w-full' : 'w-full'}}">
                <div class="p-5">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-white text-[14px] leading-[22px] font-medium font-Figtree">
                                {{ __('Subscription') }}
                            </p>
                            <p class="text-gradient-1 font-Figtree text-[28px] leading-9 font-semibold mt-1">
                                {{ optional($subscription->package)->name }}</p>
                        </div>
                        <div class="text-right">
                            <p class="text-white font-RedHat text-[24px] leading-8 font-bold">{{ ceil($creditUsed) }}</p>
                            <p class="text-white font-RedHat text-[12px] leading-[18px] font-normal mt-1">/
                                @if (!in_array($subscription->status, ['Active', 'Cancel']))
                                    0
                                @elseif ($creditLimit == -1)
                                    {{  __('Unlimited') }}
                                @else
                                    {{ $creditLimit }}
                                @endif
                        </div>
                    </div>
                    <div class="relative h-2 w-full bg-color-47 rounded-[25px] border border-color-47 mt-5 overflow-hidden">
                        <div class="progress-fill absolute h-full rounded-[60px] transition-all duration-1000" style="width: {{ $creditLimit == -1 ? 0 : max(0, min(100, 100 - $creditPercentage)) }}%"></div>
                    </div>
                    <p class="text-white font-Figtree mt-4 font-normal text-[12px] leading-[18px] break-words">
                        @if (!in_array($subscription->status, ['Active', 'Cancel']))
                            {{ __('To ensure uninterrupted service, kindly renew your current plan or subscribe to a new one, as your current plan is inactive.') }}
                        @elseif ($subscription->renewable)
                            {{ __('Your next payment is :x. Your payment will be automatically renewed each :y.', ['x' => formatNumber($subscription->package?->sale_price[$subscription->billing_cycle]), 'y' => ($subscription->billing_cycle == 'days' ? $subscription->duration . ' ' : '') . $subscription->billing_cycle ]) }}</p>
                        @else
                            {{ __('Your plan will expire on :x as it is not renewable.', ['x' => timezoneFormatDate($subscription->next_billing_date)]) }}</p>
                        @endif
                    <a href="{{ route('user.package') }}"
                        class="font-Figtree text-[13px] text-white flex gap-[2px] items-center leading-5 font-medium mt-5 group">
                        <span class="underline">{{ __('See details') }}</span>
                        <svg class="transition-transform group-hover:translate-x-0.5 group-hover:-translate-y-0.5" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                            <path d="M10.0666 3.35133C10.0755 2.96917 9.7725 2.66614 9.39034 2.67512L4.49871 2.78997C4.11655 2.79894 3.79895 3.11654 3.78998 3.4987C3.78101 3.88086 4.08404 4.18388 4.46619 4.17491L7.69012 4.09769L2.89016 8.89765C2.61324 9.17457 2.60297 9.61176 2.86719 9.87598C3.1314 10.1402 3.56859 10.1299 3.84551 9.85301L8.64391 5.05461L8.56982 8.2754C8.56084 8.65756 8.86387 8.96059 9.24603 8.95162C9.62819 8.94264 9.94579 8.62505 9.95476 8.24289L10.0696 3.35126L10.0666 3.35133Z"fill="white" />
                        </svg>
                    </a>
                </div>
                <div class="dash-sub-plan w-full magic-bg rounded-xl p-5 pr-2 flex justify-between items-center mt-[26px] lg:absolute lg:bottom-0">
                    <div>
                        <p class="uppercase font-Figtree text-white tracking-[0.27em] text-[12px] leading-[18px] font-medium "> {{ __('PROFILE') }}</p>
                        <a href="{{ route('user.profile') }}" class="text-white mt-1.5 block font-semibold font-Figtree text-[18px] leading-[26px] hover:opacity-90 transition-opacity">
                            {{ Auth::user()->name }}</a>
                    </div>
                    <div class="flex items-center mr-2">
                        <a class="text-white text-16 cursor-pointer font-normal font-Figtree flex text-center items-center justify-center rounded-full h-[60px] w-[60px] transition-transform hover:scale-105" href="{{ route('user.profile') }}">
                            <img class="rounded-full cursor-pointer bg-white h-[60px] w-[60px] object-cover" src="{{ Auth::user()->fileUrl() }}" alt="Avatar of User">
                        </a>
                    </div>
                </div>
            </div>
            @endif
        @endif
    </div>

    {{-- Most Popular Use Cases --}}
    @if (count($mostPopularUseCases) != 0)
    <div class="sm:mt-7 mt-6 animate-on-scroll">
        <div class="flex justify-between items-center gap-3">
            <p class="text-[20px] font-medium font-Figtree leading-[26px] text-color-14 dark:text-white">
                {{ __('Most recent use cases') }}</p>
            <a href="{{ route('openai') }}" class="flex justify-center items-center gap-1 font-Figtree text-color-89 text-[14px] leading-[22px] font-medium hover:text-color-14 dark:hover:text-white transition-colors">
                <span>{{ __('See All') }}</span>
                <svg class="w-3 h-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 12" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.18306 9.83263C4.42714 10.0558 4.82286 10.0558 5.06694 9.83263L8.81694 6.40406C9.06102 6.1809 9.06102 5.8191 8.81694 5.59594L5.06694 2.16737C4.82286 1.94421 4.42714 1.94421 4.18306 2.16737C3.93898 2.39052 3.93898 2.75233 4.18306 2.97549L7.49112 6L4.18306 9.02451C3.93898 9.24767 3.93898 9.60948 4.18306 9.83263Z" fill="currentColor" />
                </svg>
            </a>
        </div>
        <div class="mt-4 grid 2xl:grid-cols-4 xs:grid-cols-2 grid-cols-1 gap-4">
            @foreach($mostPopularUseCases as $useCase)
            <a class="bg-white dark:bg-color-3A md:p-6 p-4 rounded-xl transition-all hover:shadow-lg hover:-translate-y-1" href="{{ route('user.template', ['slug' => $useCase->slug]) }}">
                <img class="w-8 h-8 rounded-full" src="{{ asset($useCase->fileUrl()) }}" alt="{{ __('Image') }}">
                <p class="mt-[18px] text-color-14 dark:text-white text-[15px] leading-[22px] font-Figtree font-medium">
                    {{ $useCase->name }}</p>
                <p class="font-light pt-2 text-color-14 dark:text-white text-[13px] leading-5 font-Figtree break-all line-clamp-2">
                    {{ $useCase->description }}
                </p>
            </a>
            @endforeach
        </div>
    </div>
    @endif

    {{-- Banners --}}
    <div class="sm:mt-7 mt-6 grid lg:grid-cols-2 grid-cols-1 gap-4 animate-on-scroll">
        <a href="{{ route('user.image.create') }}" class="group">
            <div class="rounded-l-[10px] bg-tem1 h-full overflow-hidden">
                <div class="pt-8 pl-6 pb-6 banner-details-rtl transition-transform group-hover:translate-x-1">
                    <p class="text-gradient-1 font-Figtree uppercase text-[13px] leading-5 tracking-[0.15] font-semibold">
                        {{ __('Image Maker') }}</p>
                    <p class="mt-2 text-white font-bold font-RedHat text-[22px] leading-[30px] w-[250px]">
                        {{ __('Create whatever image you have in mind') }}</p>
                    <div class="mt-[38px] text-white text-[15px] leading-[22px] font-Figtree font-medium flex items-center gap-2 mb-3">
                        <span>{{ __('Create Images') }}</span>
                        <svg class="transition-transform group-hover:translate-x-1" xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none">
                            <path d="M10.7698 5.02948C11.0767 4.73663 11.0767 4.26103 10.7698 3.96818L6.84101 0.219641C6.53407 -0.0732136 6.0356 -0.0732136 5.72867 0.219641C5.42173 0.512495 5.42173 0.98809 5.72867 1.28094L8.31921 3.75029H0.785758C0.351136 3.75029 0 4.08532 0 4.5C0 4.91468 0.351136 5.24971 0.785758 5.24971H8.31676L5.73112 7.71905C5.42419 8.01191 5.42419 8.4875 5.73112 8.78036C6.03806 9.07321 6.53653 9.07321 6.84346 8.78036L10.7723 5.03182L10.7698 5.02948Z" fill="#E22861" />
                        </svg>
                    </div>
                </div>
            </div>
        </a>
        <a href="{{ route('user.codeTemplate') }}" class="group">
            <div class="bg-tem2 rounded-l-[10px] h-full overflow-hidden">
                <div class="pt-8 pl-6 mb-6 banner-details-rtl transition-transform group-hover:translate-x-1">
                    <p class="text-white font-Figtree uppercase text-[13px] leading-5 tracking-[0.15] font-semibold">
                        {{ __('Code Writer') }}</p>
                    <p class="mt-2 text-white font-bold font-RedHat text-[22px] leading-[30px] w-[250px]">
                        {{ __('Instantly get the code you are looking for') }}</p>
                    <div class="mt-[38px] text-white text-[15px] leading-[22px] font-Figtree font-medium flex items-center gap-2 mb-3">
                        <span>{{ __('Get codes') }}</span>
                        <svg class="text-white dark:text-[#FCCA19] transition-transform group-hover:translate-x-1" xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none">
                            <path d="M10.7698 5.02948C11.0767 4.73663 11.0767 4.26103 10.7698 3.96818L6.84101 0.219641C6.53407 -0.0732136 6.0356 -0.0732136 5.72867 0.219641C5.42173 0.512495 5.42173 0.98809 5.72867 1.28094L8.31921 3.75029H0.785758C0.351136 3.75029 0 4.08532 0 4.5C0 4.91468 0.351136 5.24971 0.785758 5.24971H8.31676L5.73112 7.71905C5.42419 8.01191 5.42419 8.4875 5.73112 8.78036C6.03806 9.07321 6.53653 9.07321 6.84346 8.78036L10.7723 5.03182L10.7698 5.02948Z" fill="currentColor" />
                        </svg>
                    </div>
                </div>
            </div>
        </a>
    </div>

    {{-- ============================================
        AI PRODUCTS SECTION - Banner Style
        ============================================ --}}
    <div class="sm:mt-7 mt-6 animate-on-scroll">
        <div class="flex justify-between items-center gap-3 mb-5">
            <p class="text-[20px] font-medium font-Figtree leading-[26px] text-color-14 dark:text-white">
                {{ __('Trending AI Tools') }}</p>
        </div>
        
        {{-- Banner Grid - 2 Featured + 3 Compact --}}
        <div class="grid lg:grid-cols-2 grid-cols-1 gap-4 mb-4">
            {{-- Marketing Bot - Featured Banner --}}
            <a href="{{ route('user.marketing-bot.template') }}" class="ai-banner-card group relative overflow-hidden rounded-2xl p-6 min-h-[160px] flex flex-col justify-between bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800">
                <div class="relative z-10">
                    <div class="flex items-center gap-2 mb-2">
                        <span class="inline-flex items-center px-2.5 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider bg-white/20 text-white backdrop-blur-sm">
                            <span class="w-1.5 h-1.5 rounded-full bg-green-400 mr-1.5 animate-pulse"></span>
                            {{ __('New') }}
                        </span>
                    </div>
                    <h3 class="text-white text-[22px] leading-7 font-Figtree font-bold mb-1">
                        {{ __('Marketing Bot') }}</h3>
                    <p class="text-white/80 text-[14px] leading-5 font-Figtree max-w-[280px]">
                        {{ __('Automate campaigns with AI-driven insights and analytics') }}</p>
                </div>
                <div class="flex items-center gap-2 text-white/90 text-[13px] font-medium group-hover:text-white transition-colors relative z-10">
                    <span>{{ __('Get Started') }}</span>
                    <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                    </svg>
                </div>
                {{-- Decorative Elements --}}
                <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-1/2 translate-x-1/2"></div>
                <div class="absolute bottom-0 right-8 w-20 h-20 bg-white/5 rounded-full translate-y-1/2"></div>
                <div class="ai-banner-icon absolute right-6 top-1/2 -translate-y-1/2 w-24 h-24 rounded-2xl bg-white/10 backdrop-blur-sm flex items-center justify-center transition-transform group-hover:scale-110 group-hover:rotate-3">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
            </a>

            {{-- AI Chatbot - Featured Banner --}}
            <a href="{{ route('aichatbot.index') }}" class="ai-banner-card group relative overflow-hidden rounded-2xl p-6 min-h-[160px] flex flex-col justify-between bg-gradient-to-br from-violet-600 via-purple-700 to-fuchsia-800">
                <div class="relative z-10">
                    <div class="flex items-center gap-2 mb-2">
                        <span class="inline-flex items-center px-2.5 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider bg-white/20 text-white backdrop-blur-sm">
                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                            </svg>
                            {{ __('Popular') }}
                        </span>
                    </div>
                    <h3 class="text-white text-[22px] leading-7 font-Figtree font-bold mb-1">
                        {{ __('AI Chatbot') }}</h3>
                    <p class="text-white/80 text-[14px] leading-5 font-Figtree max-w-[280px]">
                        {{ __('Build intelligent chatbots trained on your data') }}</p>
                </div>
                <div class="flex items-center gap-2 text-white/90 text-[13px] font-medium group-hover:text-white transition-colors relative z-10">
                    <span>{{ __('Create Chatbot') }}</span>
                    <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                    </svg>
                </div>
                {{-- Decorative Elements --}}
                <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-1/2 translate-x-1/2"></div>
                <div class="absolute bottom-0 right-8 w-20 h-20 bg-white/5 rounded-full translate-y-1/2"></div>
                <div class="ai-banner-icon absolute right-6 top-1/2 -translate-y-1/2 w-24 h-24 rounded-2xl bg-white/10 backdrop-blur-sm flex items-center justify-center transition-transform group-hover:scale-110 group-hover:rotate-3">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                    </svg>
                </div>
            </a>
        </div>

        {{-- Compact Cards Row --}}
        <div class="grid lg:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-4">
            {{-- AI Chat --}}
            <a href="{{ route('chat.index') }}" class="ai-compact-card group relative overflow-hidden rounded-xl bg-white dark:bg-color-3A border border-color-DF dark:border-color-47 p-5 flex items-center gap-4 transition-all hover:border-purple-300 dark:hover:border-purple-600 hover:shadow-lg hover:shadow-purple-500/10">
                <div class="ai-compact-icon w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-pink-600 flex items-center justify-center flex-shrink-0 transition-transform group-hover:scale-110 group-hover:rotate-3">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-2 mb-0.5">
                        <h3 class="text-color-14 dark:text-white text-[16px] leading-6 font-Figtree font-semibold">
                            {{ __('AI Chat') }}</h3>
                        <span class="badge-hot text-[9px] px-1.5 py-0.5 rounded font-bold uppercase">{{ __('Hot') }}</span>
                    </div>
                    <p class="text-color-89 dark:text-color-DF text-[13px] leading-5 font-Figtree truncate">
                        {{ __('Conversational AI with context memory') }}</p>
                </div>
                <svg class="w-5 h-5 text-color-89 dark:text-color-DF flex-shrink-0 transition-all group-hover:text-purple-600 dark:group-hover:text-purple-400 group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </a>

            {{-- AI Avatar --}}
            <a href="{{ route('user.ai-avatar.template') }}" class="ai-compact-card group relative overflow-hidden rounded-xl bg-white dark:bg-color-3A border border-color-DF dark:border-color-47 p-5 flex items-center gap-4 transition-all hover:border-emerald-300 dark:hover:border-emerald-600 hover:shadow-lg hover:shadow-emerald-500/10">
                <div class="ai-compact-icon w-14 h-14 rounded-xl bg-gradient-to-br from-emerald-500 to-teal-600 flex items-center justify-center flex-shrink-0 transition-transform group-hover:scale-110 group-hover:rotate-3">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <h3 class="text-color-14 dark:text-white text-[16px] leading-6 font-Figtree font-semibold mb-0.5">
                        {{ __('AI Avatar') }}</h3>
                    <p class="text-color-89 dark:text-color-DF text-[13px] leading-5 font-Figtree truncate">
                        {{ __('Generate unique AI avatars for content') }}</p>
                </div>
                <svg class="w-5 h-5 text-color-89 dark:text-color-DF flex-shrink-0 transition-all group-hover:text-emerald-600 dark:group-hover:text-emerald-400 group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </a>

            {{-- AI Persona --}}
            <a href="{{ route('user.ai-persona.template') }}" class="ai-compact-card group relative overflow-hidden rounded-xl bg-white dark:bg-color-3A border border-color-DF dark:border-color-47 p-5 flex items-center gap-4 transition-all hover:border-pink-300 dark:hover:border-pink-600 hover:shadow-lg hover:shadow-pink-500/10">
                <div class="ai-compact-icon w-14 h-14 rounded-xl bg-gradient-to-br from-pink-500 to-rose-600 flex items-center justify-center flex-shrink-0 transition-transform group-hover:scale-110 group-hover:rotate-3">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-2 mb-0.5">
                        <h3 class="text-color-14 dark:text-white text-[16px] leading-6 font-Figtree font-semibold">
                            {{ __('AI Persona') }}</h3>
                    </div>
                    <p class="text-color-89 dark:text-color-DF text-[13px] leading-5 font-Figtree truncate">
                        {{ __('Create custom AI personas with unique tone') }}</p>
                </div>
                <svg class="w-5 h-5 text-color-89 dark:text-color-DF flex-shrink-0 transition-all group-hover:text-pink-600 dark:group-hover:text-pink-400 group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </a>
        </div>
    </div>

    {{-- ============================================
         RECENT DOCUMENTS & IMAGES (Optimized)
         ============================================ --}}
    <div class="mt-6 sm:mt-7 grid xl:grid-cols-2 grid-cols-1 sm:gap-4 gap-6 animate-on-scroll">
        {{-- Recent Documents - Enhanced Layout --}}
        <div>
            <div class="flex justify-between items-center mb-5">
                <p class="text-[20px] font-medium font-Figtree leading-[26px] text-color-14 dark:text-white">
                    {{ __('Recent documents') }}</p>
                @if(count($documents) > 0)
                <a href="{{ route('user.documents') }}" class="flex items-center gap-1.5 text-color-89 text-[13px] font-medium hover:text-color-14 dark:hover:text-white transition-colors group">
                    <span>{{ __('View all') }}</span>
                    <svg class="w-4 h-4 transition-transform group-hover:translate-x-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
                @endif
            </div>
            
            @if(count($documents) > 0)
            <div class="bg-white dark:bg-color-3A rounded-2xl border border-color-DF dark:border-color-47 overflow-hidden shadow-sm">
                <ul class="divide-y divide-color-F3 dark:divide-color-47">
                    @foreach($documents as $document)
                    <li>
                        <a href="{{ route('user.editContent', ['slug' => $document->slug]) }}" class="recent-item flex items-center gap-4 p-5 group hover:bg-color-F6 dark:hover:bg-color-47 transition-colors">
                            {{-- Document Icon --}}
                            <div class="recent-item-icon flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500/10 to-purple-600/10 dark:from-purple-500/20 dark:to-purple-600/20 flex items-center justify-center border border-purple-200/50 dark:border-purple-800/30">
                                <svg class="w-6 h-6 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                            </div>
                            {{-- Content --}}
                            <div class="flex-1 min-w-0">
                                <p class="text-color-14 dark:text-white text-[15px] font-semibold font-Figtree leading-[22px] truncate group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors">
                                    {{ trimWords($document->title, 40) }}</p>
                                <div class="flex items-center gap-2.5 mt-2">
                                    @if($document->useCase)
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-md bg-color-F3 dark:bg-color-47 text-color-89 dark:text-color-DF text-[11px] font-medium">
                                        {{ Str::limit(optional($document->useCase)->name, 15) }}
                                    </span>
                                    @endif
                                    <span class="flex items-center gap-1.5 text-color-89 dark:text-color-DF text-[12px] font-Figtree">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        {{ timeToGo($document->created_at, false, 'ago') }}
                                    </span>
                                </div>
                            </div>
                            {{-- Arrow --}}
                            <div class="flex-shrink-0 w-8 h-8 rounded-lg bg-color-F6 dark:bg-color-47 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-all group-hover:bg-purple-50 dark:group-hover:bg-purple-900/20">
                                <svg class="w-4 h-4 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                </svg>
                            </div>
                        </a>
                    </li>
                    @endforeach
                </ul>
            </div>
            @else
            {{-- Empty State --}}
            <div class="bg-white dark:bg-color-3A rounded-2xl border border-color-DF dark:border-color-47">
                <div class="empty-state py-16">
                    <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-purple-100 to-pink-100 dark:from-purple-900/20 dark:to-pink-900/20 flex items-center justify-center">
                        <svg class="w-10 h-10 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                    </div>
                    <p class="text-color-14 dark:text-white text-[16px] font-semibold font-Figtree mb-1">
                        {{ __('No documents yet') }}</p>
                    <p class="text-color-89 dark:text-color-DF text-[13px] font-Figtree mb-5">
                        {{ __('Start creating your first document') }}</p>
                    <a href="{{ route('openai') }}" class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-purple-600 to-pink-600 text-white text-[13px] font-semibold hover:shadow-lg hover:shadow-purple-500/25 transition-all">
                        {{ __('Create your first document') }}
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                </div>
            </div>
            @endif
        </div>

        {{-- Recent Images - Matching Documents Style --}}
        <div>
            <div class="flex justify-between items-center mb-5">
                <p class="text-[20px] font-medium font-Figtree leading-[26px] text-color-14 dark:text-white">
                    {{ __('Last created images') }}</p>
                @if(count($images) > 0)
                <a href="{{ route('user.image.index') }}" class="flex items-center gap-1.5 text-color-89 text-[13px] font-medium hover:text-color-14 dark:hover:text-white transition-colors group">
                    <span>{{ __('View all') }}</span>
                    <svg class="w-4 h-4 transition-transform group-hover:translate-x-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
                @endif
            </div>

            @if(count($images) > 0)
            <div class="bg-white dark:bg-color-3A rounded-2xl overflow-hidden border border-color-DF dark:border-color-47 shadow-sm">
                {{-- Featured Image Banner - Reduced Height --}}
                <div class="relative group">
                    <div class="image-banner-featured relative h-[180px] overflow-hidden">
                        <a href="{{ route("user.gallery.show") . "?slug={$images[0]->slug}" }}" class="block w-full h-full">
                            <img class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-105" 
                                 src="{{ $images[0]->imageUrl() }}" 
                                 alt="{{ $images[0]->name }}" 
                                 loading="lazy">
                        </a>

                        {{-- Gradient Overlay --}}
                        <div class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/30 to-transparent pointer-events-none"></div>

                        {{-- Content Overlay --}}
                        <div class="absolute inset-0 flex flex-col justify-between p-4 pointer-events-none">
                            {{-- Top Section - Badges --}}
                            <div class="flex items-start justify-between">
                                <div class="flex items-center gap-2">
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-[10px] font-bold uppercase tracking-wider bg-purple-600/90 text-white backdrop-blur-sm shadow-lg">
                                        <svg class="w-3 h-3 mr-1.5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"/>
                                        </svg>
                                        {{ __('Featured') }}
                                    </span>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded-md bg-black/40 backdrop-blur-sm text-white text-[10px] font-medium">
                                        {{ timeToGo($images[0]->created_at, false, 'ago') }}
                                    </span>
                                </div>

                                {{-- Action Buttons --}}
                                <div class="flex gap-2 pointer-events-auto">
                                    <a href="{{ route("user.gallery.show") . "?slug={$images[0]->slug}" }}" 
                                       target="_blank"
                                       rel="noopener noreferrer"
                                       class="image-action-btn w-8 h-8 rounded-lg bg-white/20 backdrop-blur-md border border-white/30 flex items-center justify-center text-white hover:bg-white hover:text-gray-900 transition-all duration-300" 
                                       title="{{ __('View Image') }}">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                    </a>
                                    <a href="{{ $images[0]->imageUrl() }}" 
                                       download="{{ $images[0]->name }}"
                                       class="image-action-btn w-8 h-8 rounded-lg bg-white/20 backdrop-blur-md border border-white/30 flex items-center justify-center text-white hover:bg-white hover:text-gray-900 transition-all duration-300" 
                                       title="{{ __('Download Image') }}">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            {{-- Bottom Section - Image Info --}}
                            <div class="pointer-events-auto">
                                <h3 class="text-white text-[14px] font-semibold font-Figtree line-clamp-1 mb-1.5">
                                    {{ $images[0]->name }}
                                </h3>

                                {{-- Metadata Badges --}}
                                <div class="flex flex-wrap items-center gap-2">
                                    <span class="inline-flex items-center gap-1.5 px-2 py-0.5 rounded-md bg-white/15 backdrop-blur-sm text-white text-[10px] font-medium">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                        {{ $images[0]->size }}
                                    </span>
                                    @if(isset($images[0]->useCase) && $images[0]->useCase)
                                    <span class="inline-flex items-center gap-1.5 px-2 py-0.5 rounded-md bg-purple-500/30 backdrop-blur-sm text-white text-[10px] font-medium">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                        </svg>
                                        {{ Str::limit($images[0]->useCase->name, 15) }}
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Thumbnail Grid --}}
                @if(count($images) > 1)
                <div class="p-3 border-t border-color-DF dark:border-color-47">
                    <div class="flex items-center justify-between mb-3">
                        <p class="text-color-14 dark:text-white text-[13px] font-semibold font-Figtree">
                            {{ __('More Images') }}</p>
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-purple-50 dark:bg-purple-900/20 text-purple-700 dark:text-purple-300 text-[10px] font-semibold">
                            +{{ count($images) - 1 }}
                        </span>
                    </div>

                    <div class="grid grid-cols-3 gap-2.5">
                        @foreach($images->skip(1)->take(3) as $image)
                        <div class="image-thumbnail-card group relative aspect-square overflow-hidden rounded-xl bg-color-F6 dark:bg-color-47 border border-color-DF dark:border-color-47 hover:border-purple-400 dark:hover:border-purple-600 transition-all duration-300">
                            <a href="{{ route("user.gallery.show") . "?slug={$image->slug}" }}" class="block w-full h-full">
                                <img class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110" 
                                     src="{{ $image->imageUrl() }}" 
                                     alt="{{ $image->name }}" 
                                     loading="lazy">
                            </a>

                            {{-- Hover Overlay --}}
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none"></div>

                            {{-- Quick Actions --}}
                            <div class="absolute inset-0 flex items-center justify-center gap-2 opacity-0 group-hover:opacity-100 transition-all duration-300">
                                <a href="{{ route("user.gallery.show") . "?slug={$image->slug}" }}" 
                                   target="_blank"
                                   rel="noopener noreferrer"
                                   class="w-7 h-7 rounded-lg bg-white/90 backdrop-blur-sm flex items-center justify-center text-gray-900 hover:bg-white hover:scale-110 transition-all" 
                                   title="{{ __('View') }}">
                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                    </svg>
                                </a>
                                <a href="{{ $image->imageUrl() }}" 
                                   download="{{ $image->name }}"
                                   class="w-7 h-7 rounded-lg bg-white/90 backdrop-blur-sm flex items-center justify-center text-gray-900 hover:bg-white hover:scale-110 transition-all" 
                                   title="{{ __('Download') }}">
                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
            @else
            {{-- Empty State --}}
            <div class="bg-white dark:bg-color-3A rounded-2xl border border-color-DF dark:border-color-47">
                <div class="empty-state py-16">
                    <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-pink-100 to-purple-100 dark:from-pink-900/20 dark:to-purple-900/20 flex items-center justify-center">
                        <svg class="w-10 h-10 text-pink-600 dark:text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                    </div>
                    <p class="text-color-14 dark:text-white text-[16px] font-semibold font-Figtree mb-1">
                        {{ __('No images yet') }}</p>
                    <p class="text-color-89 dark:text-color-DF text-[13px] font-Figtree mb-5">
                        {{ __('Start creating amazing AI-generated images') }}</p>
                    <a href="{{ route('user.image.create') }}" class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-pink-600 to-purple-600 text-white text-[13px] font-semibold hover:shadow-lg hover:shadow-pink-500/25 transition-all">
                        {{ __('Create your first image') }}
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                </div>
            </div>
            @endif
        </div>
    </div>

    {{-- ============================================
         SUPPORT SECTION - Modern Professional Design
         ============================================ --}}
    <div class="lg:mt-7 mt-6 animate-on-scroll">
        <div class="grid {{ $totalTickets > 0 ? 'lg:grid-cols-2' : 'lg:grid-cols-1' }} grid-cols-1 gap-4">
            {{-- Need Help Banner Card - Enhanced --}}
            <div class="support-help-banner relative overflow-hidden rounded-2xl bg-gradient-to-br from-indigo-600 via-purple-600 to-pink-600 shadow-lg hover:shadow-xl transition-all {{ $totalTickets == 0 ? 'lg:col-span-1' : '' }}">
                {{-- Animated Background Pattern --}}
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-64 h-64 bg-white rounded-full -translate-y-1/2 translate-x-1/2 blur-3xl"></div>
                    <div class="absolute bottom-0 left-0 w-48 h-48 bg-white rounded-full translate-y-1/2 -translate-x-1/2 blur-2xl"></div>
                </div>
                
                <div class="relative z-10 p-8 flex flex-col items-center text-center">
                    {{-- Icon with Pulse Animation --}}
                    <div class="relative mb-5">
                        <div class="absolute inset-0 w-20 h-20 bg-white/30 rounded-full blur-xl animate-pulse"></div>
                        <div class="relative w-20 h-20 rounded-2xl bg-white/20 backdrop-blur-md border border-white/40 flex items-center justify-center shadow-2xl transform hover:scale-105 transition-transform">
                            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                    </div>
                    
                    {{-- Content --}}
                    <h3 class="text-white text-[26px] leading-[32px] font-Figtree font-bold mb-2">
                        {{ __('Need Help?') }}
                    </h3>
                    <p class="text-white/95 text-[15px] leading-6 font-Figtree mb-6 {{ $totalTickets == 0 ? 'max-w-[500px]' : 'max-w-[300px]' }}">
                        {{ __('Our support team is ready to assist you with any questions') }}
                    </p>
                    
                    {{-- CTA Button with Hover Effect --}}
                    <a href="{{ route('user.ticketAdd') }}" class="support-cta-btn group inline-flex items-center gap-2.5 px-7 py-3.5 rounded-xl bg-white text-indigo-600 text-[15px] font-bold hover:shadow-2xl hover:shadow-white/30 transition-all transform hover:scale-105 hover:-translate-y-0.5">
                        <svg class="w-5 h-5 transition-transform group-hover:rotate-90" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4v16m8-8H4"/>
                        </svg>
                        <span>{{ __('Create Support Ticket') }}</span>
                        <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>

            {{-- Support Tickets List Card - Only Show if Tickets Exist --}}
            @if($totalTickets > 0)
            <div class="bg-white dark:bg-color-3A rounded-2xl border border-color-DF dark:border-color-47 overflow-hidden shadow-sm hover:shadow-md transition-shadow">
            {{-- Header - Improved --}}
            <div class="p-5 border-b border-color-DF dark:border-color-47 bg-gradient-to-r from-indigo-50/50 to-purple-50/50 dark:from-indigo-900/10 dark:to-purple-900/10">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="w-11 h-11 rounded-xl bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center shadow-lg shadow-indigo-500/25">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-color-14 dark:text-white text-[18px] leading-6 font-Figtree font-bold">
                                {{ __('Support Tickets') }}
                            </h3>
                            <div class="flex items-center gap-2 mt-0.5">
                                <span class="inline-flex items-center gap-1 text-color-89 dark:text-color-DF text-[12px] font-medium font-Figtree">
                                    <svg class="w-3.5 h-3.5" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $totalTickets }} {{ __('total') }}
                                </span>
                                @if($openTickets > 0)
                                <span class="text-color-89 dark:text-color-DF text-[12px]">•</span>
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 text-[11px] font-semibold">
                                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $openTickets }} {{ __('open') }}
                                </span>
                                @endif
                                @if(isset($closedTickets) && $closedTickets > 0)
                                <span class="text-color-89 dark:text-color-DF text-[12px]">•</span>
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md bg-purple-100 dark:bg-purple-900/30 text-purple-700 dark:text-purple-400 text-[11px] font-semibold">
                                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $closedTickets }} {{ __('closed') }}
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    @if($totalTickets > 0)
                    <a href="{{ route('user.ticketList') }}" class="flex items-center gap-1.5 text-indigo-600 dark:text-indigo-400 text-[13px] font-semibold hover:text-indigo-700 dark:hover:text-indigo-300 transition-colors group">
                        <span>{{ __('View all') }}</span>
                        <svg class="w-4 h-4 transition-transform group-hover:translate-x-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                    @endif
                </div>
            </div>

            {{-- Tickets List - Redesigned --}}
            @if(count($recentTickets) > 0)
            <div class="divide-y divide-color-DF dark:divide-color-47">
                @foreach($recentTickets as $ticket)
                <a href="{{ route('user.threadReply', $ticket->id) }}" class="support-ticket-item group block p-5 hover:bg-gradient-to-r hover:from-indigo-50/50 hover:to-purple-50/50 dark:hover:from-indigo-900/10 dark:hover:to-purple-900/10 transition-all">
                    <div class="flex items-start gap-4">
                        {{-- Ticket Icon & ID --}}
                        <div class="flex-shrink-0 pt-0.5">
                            <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-indigo-100 to-purple-100 dark:from-indigo-900/30 dark:to-purple-900/30 flex items-center justify-center group-hover:scale-110 group-hover:shadow-lg transition-all">
                                <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                                </svg>
                            </div>
                        </div>
                        
                        {{-- Content --}}
                        <div class="flex-1 min-w-0">
                            <div class="flex items-start justify-between gap-3 mb-2">
                                <div class="flex-1 min-w-0">
                                    <h4 class="text-color-14 dark:text-white text-[15px] font-Figtree font-semibold line-clamp-1 group-hover:text-indigo-600 dark:group-hover:text-indigo-400 transition-colors">
                                        {{ $ticket->subject }}
                                    </h4>
                                    <p class="text-indigo-600 dark:text-indigo-400 text-[12px] font-mono font-semibold mt-1">
                                        {{ $ticket->thread_key }}
                                    </p>
                                </div>
                                
                                {{-- Status Badge --}}
                                @if($ticket->threadStatus)
                                <div class="flex-shrink-0">
                                    @php
                                        $statusName = strtolower($ticket->threadStatus->name);
                                        $statusBg = 'bg-gray-100 dark:bg-gray-900/30 text-gray-700 dark:text-gray-400';
                                        $statusDot = 'bg-gray-500';
                                        
                                        if(str_contains($statusName, 'open') || str_contains($statusName, 'progress')) {
                                            $statusBg = 'bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400';
                                            $statusDot = 'bg-green-500';
                                        } elseif(str_contains($statusName, 'pending') || str_contains($statusName, 'waiting')) {
                                            $statusBg = 'bg-yellow-100 dark:bg-yellow-900/30 text-yellow-700 dark:text-yellow-400';
                                            $statusDot = 'bg-yellow-500';
                                        } elseif(str_contains($statusName, 'closed') || str_contains($statusName, 'resolved')) {
                                            $statusBg = 'bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-400';
                                            $statusDot = 'bg-blue-500';
                                        }
                                    @endphp
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg text-[11px] font-bold uppercase tracking-wide {{ $statusBg }} shadow-sm">
                                        <span class="w-1.5 h-1.5 rounded-full {{ $statusDot }} animate-pulse"></span>
                                        {{ $ticket->threadStatus->name }}
                                    </span>
                                </div>
                                @endif
                            </div>
                            
                            {{-- Meta Info --}}
                            <div class="flex flex-wrap items-center gap-3 text-[12px] text-color-89 dark:text-color-DF">
                                @if($ticket->priority)
                                <span class="inline-flex items-center gap-1.5">
                                    @php
                                        $priorityName = strtolower($ticket->priority->name);
                                        $priorityColor = 'text-gray-600 dark:text-gray-400';
                                        
                                        if(str_contains($priorityName, 'high') || str_contains($priorityName, 'urgent')) {
                                            $priorityColor = 'text-red-600 dark:text-red-400';
                                        } elseif(str_contains($priorityName, 'medium')) {
                                            $priorityColor = 'text-orange-600 dark:text-orange-400';
                                        } elseif(str_contains($priorityName, 'low')) {
                                            $priorityColor = 'text-green-600 dark:text-green-400';
                                        }
                                    @endphp
                                    <svg class="w-3.5 h-3.5 {{ $priorityColor }}" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.707a1 1 0 010-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 01-1.414 1.414L11 5.414V17a1 1 0 11-2 0V5.414L6.707 7.707a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="font-medium {{ $priorityColor }}">{{ $ticket->priority->name }}</span>
                                </span>
                                @endif
                                
                                <span class="inline-flex items-center gap-1.5">
                                    <svg class="w-3.5 h-3.5" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="font-medium">{{ timeToGo($ticket->last_reply, false, 'ago') }}</span>
                                </span>
                            </div>
                        </div>
                        
                        {{-- Arrow Icon --}}
                        <div class="flex-shrink-0 pt-3">
                            <div class="w-7 h-7 rounded-lg bg-color-F6 dark:bg-color-47 flex items-center justify-center opacity-0 group-hover:opacity-100 group-hover:bg-indigo-100 dark:group-hover:bg-indigo-900/30 transition-all">
                                <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400 transition-transform group-hover:translate-x-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </a>
                @endforeach
            </div>
            @else
            {{-- Empty State - Enhanced --}}
            <div class="p-12 text-center">
                <div class="w-20 h-20 mx-auto mb-5 rounded-2xl bg-gradient-to-br from-indigo-100 to-purple-100 dark:from-indigo-900/30 dark:to-purple-900/30 flex items-center justify-center">
                    <svg class="w-10 h-10 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
                    </svg>
                </div>
                <h4 class="text-color-14 dark:text-white text-[16px] font-bold font-Figtree mb-2">
                    {{ __('No tickets yet') }}
                </h4>
                <p class="text-color-89 dark:text-color-DF text-[14px] font-Figtree mb-6 max-w-[260px] mx-auto">
                    {{ __('Need assistance? Create a support ticket and our team will help you') }}
                </p>
                <a href="{{ route('user.ticketAdd') }}" class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-indigo-600 to-purple-600 text-white text-[14px] font-semibold hover:shadow-lg hover:shadow-indigo-500/25 transition-all transform hover:scale-105">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    <span>{{ __('Create Your First Ticket') }}</span>
                </a>
            </div>
            @endif
        </div>
        @endif
        </div>
    </div>
</main>
{{-- end main content --}}
@endsection

@section('js')
<script src="{{ asset('public/assets/plugin/chart-js/chart.min.js') }}?v={{ config('artifism.version', '1.0.0') }}"></script>
<script src="{{ asset('public/assets/js/user/dashboard-enhanced.js') }}?v={{ config('artifism.version', '1.0.0') }}"></script>
@endsection
