<?php

namespace Modules\OpenAI\AiProviders\OpenAi\Responses\TextToVideo;

use Exception;
use Modules\OpenAI\Contracts\Responses\TextToVideo\FetchVideoResponseContact;
use Modules\OpenAI\AiProviders\OpenAi\Responses\Traits\FetchVideoTrait;

class FetchVideoResponse implements FetchVideoResponseContact
{
    use FetchVideoTrait;

    public array $response;
    public array $urls = [];

    public function __construct(array $aiResponse)
    {
        $this->response = $aiResponse;
        $this->process();
    }

    public function process(): mixed
    {
        try {
            return $this->processVideoFetch();
        } catch (\Throwable $e) {
            $this->handleException($e->getMessage());
        }
    }

    public function urls(): array
    {
        return $this->urls;
    }

    /**
     * Add video content to the urls array (implementation of abstract method)
     *
     * @param mixed $content
     * @return void
     */
    protected function addVideoContent(mixed $content): void
    {
        $this->urls[] = $content;
    }

    /**
     * Get the video content collection (implementation of abstract method)
     *
     * @return array
     */
    protected function getVideoContent(): array
    {
        return $this->urls;
    }

    /**
     * Handle exceptions.
     *
     * @param string $message
     * @return Exception
     */
    public function handleException(string $message): Exception
    {
        throw new Exception($message);
    }
}

