"use strict";$(document).ready((function(){let $subscribersDropdown,$subscribersContainer,$subscribersSearch,$subscribersLoader,$subscribersButton,$subscribersHiddenInput,$subscribersDisplay,selectedSubscribers=[],searchTimeout,isLoading=!1,currentXhr=null,currentPage=1,hasMorePages=!0,baseUrl="";function init(){$subscribersDropdown=$("#subscribers-dropdown"),$subscribersContainer=$("#subscribers-container"),$subscribersSearch=$("#subscribers-search"),$subscribersLoader=$("#subscribers-loader"),$subscribersButton=$("#subscribers-button"),$subscribersHiddenInput=$("#subscribers-hidden-input"),$subscribersDisplay=$("#subscribers-display"),0!==$subscribersDropdown.length&&0!==$subscribersContainer.length&&(baseUrl=$subscribersDropdown.attr("data-base-url")||"",attachHandlersToExistingSubscribers(),baseUrl&&loadSubscribers(!0),setupEventListeners())}function setupEventListeners(){$subscribersDropdown.on("click",(function(e){e.stopPropagation()})),$subscribersSearch.on("click",(function(e){e.stopPropagation()})),$subscribersContainer.on("click",(function(e){e.stopPropagation()})),$subscribersDropdown.on("click","*",(function(e){e.stopPropagation()})),$subscribersSearch.on("input",(function(e){clearTimeout(searchTimeout);const searchTerm=$(this).val().trim();$subscribersLoader.length>0&&(searchTerm?$subscribersLoader.removeClass("hidden"):$subscribersLoader.addClass("hidden")),searchTimeout=setTimeout((function(){loadSubscribers(!0,searchTerm)}),300)})),$subscribersContainer.on("scroll",(function(){if(isLoading||!hasMorePages)return;const $this=$(this),scrollTop=$this.scrollTop(),scrollHeight=$this[0].scrollHeight,clientHeight=$this.height();scrollTop+clientHeight>=.8*scrollHeight&&loadSubscribers(!1)}))}function loadSubscribers(reset=!1,searchTerm=""){if(isLoading)return;if(currentXhr&&4!==currentXhr.readyState&&(currentXhr.abort(),currentXhr=null),isLoading=!0,reset&&(currentPage=1,hasMorePages=!0),!baseUrl)return filterStaticSubscribers(searchTerm),attachHandlersToExistingSubscribers(),isLoading=!1,void($subscribersLoader.length>0&&$subscribersLoader.addClass("hidden"));let url=baseUrl;const params=new URLSearchParams;params.append("page",currentPage),searchTerm&&params.append("search",searchTerm),params.toString()&&(url+="?"+params.toString()),currentXhr=$.ajax({url:url,type:"GET",dataType:"json",headers:{"X-Requested-With":"XMLHttpRequest"},beforeSend:function(xhr){currentXhr=xhr},success:function(data){if(!currentXhr||"abort"!==currentXhr.statusText)if(data.success&&data.subscribers){if(reset&&$subscribersContainer.html(""),0===data.subscribers.length&&reset)return $subscribersContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <svg class="mx-auto h-12 w-12 text-color-89 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>\n                                </svg>\n                                <p class="text-sm text-color-89 dark:text-gray-400">${jsLang("No subscribers found")}</p>\n                                <p class="text-xs text-color-89 dark:text-gray-500 mt-1">${jsLang("Try adjusting your search terms")}</p>\n                            </div>\n                        `),currentPage=data.current_page,void(hasMorePages=data.has_more_pages);data.subscribers.forEach((function(subscriber){const isSelected=selectedSubscribers.includes(subscriber.id),subscriberName=subscriber.name||subscriber.phone||`Subscriber ${subscriber.id}`,$subscriberItem=$(`\n                            <div class="px-4 py-2.5 rounded-lg text-sm text-gray-700 dark:text-gray-200 hover:bg-color-F6 dark:hover:bg-color-3A cursor-pointer flex items-center gap-3 transition-colors duration-150"\n                                data-id="${subscriber.id}"\n                                data-name="${escapeHtml(subscriberName)}">\n                                <div class="relative flex items-center">\n                                    <input type="checkbox"\n                                           class="subscriber-checkbox w-4 h-4 rounded border-color-DF dark:border-color-47 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:ring-offset-0 cursor-pointer transition-all duration-150"\n                                           value="${subscriber.id}"\n                                           ${isSelected?"checked":""}>\n                                </div>\n                                <span class="flex-1 font-medium">${escapeHtml(subscriberName)}</span>\n                            </div>\n                        `);attachSubscriberHandlers($subscriberItem),$subscribersContainer.append($subscriberItem)})),currentPage=data.current_page,hasMorePages=data.has_more_pages}else reset&&$subscribersContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <p class="text-sm text-red-500">${jsLang("Failed to load subscribers")}</p>\n                            </div>\n                        `)},error:function(xhr,status,error){"abort"!==status&&(console.error("Error loading subscribers:",error),reset&&$subscribersContainer.html('\n                        <div class="px-4 py-8 text-center">\n                            <p class="text-sm text-red-500">Failed to load subscribers</p>\n                        </div>\n                    '))},complete:function(){isLoading=!1,currentXhr=null,$subscribersLoader.length>0&&$subscribersLoader.addClass("hidden")}})}function attachHandlersToExistingSubscribers(){$subscribersContainer.find(".subscriber-checkbox").each((function(){const $checkbox=$(this),$subscriberItem=$checkbox.closest("[data-id]");0!==$subscriberItem.length&&($checkbox.off("change").on("change",(function(){const subscriberId=$(this).val(),subscriberName=$subscriberItem.attr("data-name");if($(this).is(":checked"))selectedSubscribers.includes(subscriberId)||selectedSubscribers.push(subscriberId);else{const index=selectedSubscribers.indexOf(subscriberId);index>-1&&selectedSubscribers.splice(index,1)}updateSelectedDisplay()})),$checkbox.off("click").on("click",(function(e){e.stopPropagation()})),$subscriberItem.off("click").on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")})))}))}function filterStaticSubscribers(searchTerm=""){const $allItems=$subscribersContainer.find("[data-id]");if(searchTerm){const searchLower=searchTerm.toLowerCase();$allItems.each((function(){const $item=$(this),name=$item.attr("data-name")||"";name.toLowerCase().includes(searchLower)?$item.show():$item.hide()}))}else $allItems.show()}function attachSubscriberHandlers($subscriberItem){const $checkbox=$subscriberItem.find(".subscriber-checkbox");$checkbox.on("change",(function(){const subscriberId=$(this).val(),subscriberName=$(this).closest("[data-name]").attr("data-name");if($(this).is(":checked"))selectedSubscribers.includes(subscriberId)||selectedSubscribers.push(subscriberId);else{const index=selectedSubscribers.indexOf(subscriberId);index>-1&&selectedSubscribers.splice(index,1)}updateSelectedDisplay()})),$checkbox.on("click",(function(e){e.stopPropagation()})),$subscriberItem.on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")}))}function updateSelectedDisplay(){if($subscribersHiddenInput.length>0&&$subscribersHiddenInput.val(selectedSubscribers.join(",")),$subscribersDisplay.length>0)if(0===selectedSubscribers.length)$subscribersDisplay.text(jsLang("Select Subscriber"));else if(1===selectedSubscribers.length){const $selectedItem=$subscribersContainer.find(`[data-id="${selectedSubscribers[0]}"]`),subscriberName=$selectedItem.attr("data-name")||jsLang("Subscriber");$subscribersDisplay.text(subscriberName)}else $subscribersDisplay.text(`${selectedSubscribers.length} ${jsLang("subscribers selected")}`)}function escapeHtml(unsafe){if(null==unsafe)return"";const str=String(unsafe);return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}init()}));