"use strict";$(document).ready((function(){let $groupsDropdown,$groupsContainer,$groupsSearch,$groupsLoader,$groupsButton,$groupsHiddenInput,$groupsDisplay,selectedGroups=[],searchTimeout,isLoading=!1,currentXhr=null,currentPage=1,hasMorePages=!0,baseUrl="";function init(){$groupsDropdown=$("#groups-dropdown"),$groupsContainer=$("#groups-container"),$groupsSearch=$("#groups-search"),$groupsLoader=$("#groups-loader"),$groupsButton=$("#groups-button"),$groupsHiddenInput=$("#groups-hidden-input"),$groupsDisplay=$("#groups-display"),0!==$groupsDropdown.length&&0!==$groupsContainer.length&&(baseUrl=$groupsDropdown.attr("data-base-url")||"",attachHandlersToExistingGroups(),baseUrl&&loadGroups(!0),setupEventListeners())}function setupEventListeners(){$groupsDropdown.on("click",(function(e){e.stopPropagation()})),$groupsSearch.on("click",(function(e){e.stopPropagation()})),$groupsContainer.on("click",(function(e){e.stopPropagation()})),$groupsDropdown.on("click","*",(function(e){e.stopPropagation()})),$groupsSearch.on("input",(function(e){clearTimeout(searchTimeout);const searchTerm=$(this).val().trim();$groupsLoader.length>0&&(searchTerm?$groupsLoader.removeClass("hidden"):$groupsLoader.addClass("hidden")),searchTimeout=setTimeout((function(){loadGroups(!0,searchTerm)}),300)})),$groupsContainer.on("scroll",(function(){if(isLoading||!hasMorePages)return;const $this=$(this),scrollTop=$this.scrollTop(),scrollHeight=$this[0].scrollHeight,clientHeight=$this.height();scrollTop+clientHeight>=.8*scrollHeight&&loadGroups(!1)}))}function loadGroups(reset=!1,searchTerm=""){if(isLoading)return;if(currentXhr&&4!==currentXhr.readyState&&(currentXhr.abort(),currentXhr=null),isLoading=!0,reset&&(currentPage=1,hasMorePages=!0),!baseUrl)return filterStaticGroups(searchTerm),attachHandlersToExistingGroups(),isLoading=!1,void($groupsLoader.length>0&&$groupsLoader.addClass("hidden"));let url=baseUrl;const params=new URLSearchParams;params.append("page",currentPage),searchTerm&&params.append("search",searchTerm),params.toString()&&(url+="?"+params.toString()),currentXhr=$.ajax({url:url,type:"GET",dataType:"json",headers:{"X-Requested-With":"XMLHttpRequest"},beforeSend:function(xhr){currentXhr=xhr},success:function(data){if(!currentXhr||"abort"!==currentXhr.statusText)if(data.success&&data.groups){if(reset&&$groupsContainer.html(""),0===data.groups.length&&reset)return $groupsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <svg class="mx-auto h-12 w-12 text-color-89 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>\n                                </svg>\n                                <p class="text-sm text-color-89 dark:text-gray-400">${jsLang("No groups found")}</p>\n                                <p class="text-xs text-color-89 dark:text-gray-500 mt-1">${jsLang("Try adjusting your search terms")}</p>\n                            </div>\n                        `),currentPage=data.current_page,void(hasMorePages=data.has_more_pages);data.groups.forEach((function(group){const isSelected=selectedGroups.includes(group.id),$groupItem=$(`\n                            <div class="px-4 py-2.5 rounded-lg text-sm text-gray-700 dark:text-gray-200 hover:bg-color-F6 dark:hover:bg-color-3A cursor-pointer flex items-center gap-3 transition-colors duration-150"\n                                data-id="${group.id}"\n                                data-name="${escapeHtml(group.name)}">\n                                <div class="relative flex items-center">\n                                    <input type="checkbox"\n                                           class="group-checkbox w-4 h-4 rounded border-color-DF dark:border-color-47 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:ring-offset-0 cursor-pointer transition-all duration-150"\n                                           value="${group.id}"\n                                           ${isSelected?"checked":""}>\n                                </div>\n                                <span class="flex-1 font-medium">${escapeHtml(group.name)}</span>\n                            </div>\n                        `);attachGroupHandlers($groupItem),$groupsContainer.append($groupItem)})),currentPage=data.current_page,hasMorePages=data.has_more_pages}else reset&&$groupsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <p class="text-sm text-red-500">${jsLang("Failed to load groups")}</p>\n                            </div>\n                        `)},error:function(xhr,status,error){"abort"!==status&&(console.error("Error loading groups:",error),reset&&$groupsContainer.html('\n                        <div class="px-4 py-8 text-center">\n                            <p class="text-sm text-red-500">Failed to load groups</p>\n                        </div>\n                    '))},complete:function(){isLoading=!1,currentXhr=null,$groupsLoader.length>0&&$groupsLoader.addClass("hidden")}})}function attachHandlersToExistingGroups(){$groupsContainer.find(".group-checkbox").each((function(){const $checkbox=$(this),$groupItem=$checkbox.closest("[data-id]");0!==$groupItem.length&&($checkbox.off("change").on("change",(function(){const groupId=$(this).val(),groupName=$groupItem.attr("data-name");if($(this).is(":checked"))selectedGroups.includes(groupId)||selectedGroups.push(groupId);else{const index=selectedGroups.indexOf(groupId);index>-1&&selectedGroups.splice(index,1)}updateSelectedDisplay()})),$checkbox.off("click").on("click",(function(e){e.stopPropagation()})),$groupItem.off("click").on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")})))}))}function filterStaticGroups(searchTerm=""){const $allItems=$groupsContainer.find("[data-id]");if(searchTerm){const searchLower=searchTerm.toLowerCase();$allItems.each((function(){const $item=$(this),name=$item.attr("data-name")||"";name.toLowerCase().includes(searchLower)?$item.show():$item.hide()}))}else $allItems.show()}function attachGroupHandlers($groupItem){const $checkbox=$groupItem.find(".group-checkbox");$checkbox.on("change",(function(){const groupId=$(this).val(),groupName=$(this).closest("[data-name]").attr("data-name");if($(this).is(":checked"))selectedGroups.includes(groupId)||selectedGroups.push(groupId);else{const index=selectedGroups.indexOf(groupId);index>-1&&selectedGroups.splice(index,1)}updateSelectedDisplay()})),$checkbox.on("click",(function(e){e.stopPropagation()})),$groupItem.on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")}))}function updateSelectedDisplay(){if($groupsHiddenInput.length>0&&$groupsHiddenInput.val(selectedGroups.join(",")),$groupsDisplay.length>0)if(0===selectedGroups.length)$groupsDisplay.text(jsLang("Select Group"));else if(1===selectedGroups.length){const $selectedItem=$groupsContainer.find(`[data-id="${selectedGroups[0]}"]`),groupName=$selectedItem.attr("data-name")||jsLang("Group");$groupsDisplay.text(groupName)}else $groupsDisplay.text(`${selectedGroups.length} ${jsLang("groups selected")}`)}function escapeHtml(unsafe){if(null==unsafe)return"";const str=String(unsafe);return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}init()}));