"use strict";const html=document.documentElement;function rangeDays(n){const out=[];for(let i=n-1;i>=0;i--){const d=new Date;d.setDate(d.getDate()-i),out.push(`${d.getFullYear()}-${(d.getMonth()+1).toString().padStart(2,"0")}-${d.getDate().toString().padStart(2,"0")}`)}return out}function getThemeColors(){const isDark=html.classList.contains("dark");return{gridColor:isDark?"#474746":"#e2e8f0",textColor:isDark?"#898989":"#64748b",bgColor:isDark?"#3a3a39":"#ffffff"}}let lineChart,lineRequestController,donutChart,areaChart,barChart;function createLineChart(days=30){const colors=getThemeColors();lineRequestController&&lineRequestController.abort();const controller=new AbortController;lineRequestController=controller;const{signal:signal}=controller;fetch(`${SITE_URL}/user/marketing-bot/campaign-performance/${days}`,{signal:signal}).then(response=>response.json()).then(data=>{if(lineRequestController!==controller)return;const channelColors=generateColors(data.channels.length,data.channels),strokeColors=channelColors.map(color=>color),series=data.channels.map((channel,index)=>({name:channel.charAt(0).toUpperCase()+channel.slice(1),data:data.channelData[channel]})),lineOptions={chart:{type:"line",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},stroke:{curve:"smooth",width:4},series:series,xaxis:{categories:data.dates,labels:{rotate:-45,style:{colors:colors.textColor}}},yaxis:{labels:{formatter:v=>Math.round(v),style:{colors:colors.textColor}}},grid:{borderColor:colors.gridColor},markers:{size:6,strokeWidth:3,strokeColors:strokeColors},colors:channelColors,legend:{labels:{colors:colors.textColor}},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};lineChart&&lineChart.destroy(),lineChart=new ApexCharts(document.querySelector("#campaignLine"),lineOptions),lineChart.render(),lineRequestController=null}).catch(error=>{if("AbortError"===error.name)return;if(lineRequestController!==controller)return;lineRequestController=null;const emptyData={dates:rangeDays(days),channels:["whatsapp","telegram"],channelData:{whatsapp:Array(days).fill(0),telegram:Array(days).fill(0)}};renderLineChart(emptyData)})}function generateColors(count,channels=[]){const defaultColors={whatsapp:"#22c55e",telegram:"#3b82f6",email:"#f59e0b",instagram:"#d946ef",facebook:"#1877f2"},colorPalette=["#ef4444","#f97316","#eab308","#84cc16","#06b6d4","#0ea5e9","#6366f1","#8b5cf6","#a855f7","#ec4899"],colors=[];for(let i=0;i<count;i++){const channel=channels[i];channel&&defaultColors[channel]?colors.push(defaultColors[channel]):colors.push(colorPalette[i%colorPalette.length])}return colors}function renderLineChart(data){const colors=getThemeColors(),channelColors=generateColors(data.channels.length,data.channels),series=data.channels.map((channel,index)=>({name:channel.charAt(0).toUpperCase()+channel.slice(1),data:data.channelData[channel]})),lineOptions={chart:{type:"line",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},stroke:{curve:"smooth",width:4},series:series,xaxis:{categories:data.dates,labels:{rotate:-45,style:{colors:colors.textColor}}},yaxis:{labels:{formatter:v=>Math.round(v),style:{colors:colors.textColor}}},grid:{borderColor:colors.gridColor},markers:{size:6,strokeWidth:3,strokeColors:channelColors},colors:channelColors,legend:{labels:{colors:colors.textColor}},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};lineChart&&lineChart.destroy(),lineChart=new ApexCharts(document.querySelector("#campaignLine"),lineOptions),lineChart.render()}function createDonutChart(){const colors=getThemeColors();fetch(`${SITE_URL}/user/marketing-bot/channel-distribution`).then(response=>response.json()).then(data=>{const channels=data.channels||[],distribution=data.distribution||{},total=Object.values(distribution).reduce((sum,count)=>sum+count,0),series=[],labels=[];channels.forEach(channel=>{const count=distribution[channel]||0,percentage=total>0?count/total*100:0;series.push(percentage);const capitalizedChannel=channel.charAt(0).toUpperCase()+channel.slice(1).toLowerCase();labels.push(capitalizedChannel)});const dynamicColors=generateColors(channels.length,channels),donutOptions={chart:{type:"donut",height:320,background:colors.bgColor,fontFamily:"Inter"},series:series,labels:labels,legend:{position:"bottom",labels:{colors:colors.textColor}},colors:dynamicColors,dataLabels:{formatter:val=>`${val.toFixed(1)}%`,style:{fontSize:"14px",fontWeight:"600"}},plotOptions:{pie:{donut:{size:"70%"}}},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};donutChart&&donutChart.destroy(),donutChart=new ApexCharts(document.querySelector("#channelDonut"),donutOptions),donutChart.render()}).catch(error=>{const donutOptions={chart:{type:"donut",height:320,background:colors.bgColor,fontFamily:"Inter"},series:[50,50],labels:["WhatsApp","Telegram"],legend:{position:"bottom",labels:{colors:colors.textColor}},colors:["#22c55e","#3b82f6"],dataLabels:{formatter:val=>`${val.toFixed(1)}%`,style:{fontSize:"14px",fontWeight:"600"}},plotOptions:{pie:{donut:{size:"70%"}}},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};donutChart&&donutChart.destroy(),donutChart=new ApexCharts(document.querySelector("#channelDonut"),donutOptions),donutChart.render()})}function createAreaChart(){const colors=getThemeColors();fetch(`${SITE_URL}/user/marketing-bot/contact-growth`).then(response=>response.json()).then(data=>{const areaOptions={chart:{type:"area",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},stroke:{curve:"smooth",width:3},dataLabels:{enabled:!1},series:[{name:"New Contacts",data:data.counts}],xaxis:{categories:data.months,labels:{style:{colors:colors.textColor}}},yaxis:{labels:{style:{colors:colors.textColor}}},colors:["#a26ef6"],fill:{type:"gradient",gradient:{opacityFrom:.4,opacityTo:.1,colorStops:[{offset:0,color:"#a26ef6",opacity:.4},{offset:100,color:"#763cd4",opacity:.1}]}},grid:{borderColor:colors.gridColor},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};areaChart&&areaChart.destroy(),areaChart=new ApexCharts(document.querySelector("#contactsArea"),areaOptions),areaChart.render()}).catch(error=>{const areaOptions={chart:{type:"area",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},stroke:{curve:"smooth",width:3},dataLabels:{enabled:!1},series:[{name:"New Contacts",data:[20,25,22,30,28,34,40,37,45,43,50,48]}],xaxis:{categories:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],labels:{style:{colors:colors.textColor}}},yaxis:{labels:{style:{colors:colors.textColor}}},colors:["#a26ef6"],fill:{type:"gradient",gradient:{opacityFrom:.4,opacityTo:.1,colorStops:[{offset:0,color:"#a26ef6",opacity:.4},{offset:100,color:"#763cd4",opacity:.1}]}},grid:{borderColor:colors.gridColor},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};areaChart&&areaChart.destroy(),areaChart=new ApexCharts(document.querySelector("#contactsArea"),areaOptions),areaChart.render()})}function createBarChart(){const colors=getThemeColors();fetch(`${SITE_URL}/user/marketing-bot/conversions`).then(response=>{if(!response.ok)throw new Error("Network response was not ok");return response.json()}).then(data=>{const channels=data.channels||[],conversions=data.conversions||{},seriesData=[],categories=[],originalChannels=[];channels.forEach((channel,index)=>{if(channel){const count=conversions[channel]||0;if(count>0){const capitalizedChannel=channel.charAt(0).toUpperCase()+channel.slice(1).toLowerCase();categories.push(capitalizedChannel),seriesData.push(count),originalChannels.push(channel)}}});const dynamicColors=generateColors(categories.length,originalChannels),barOptions={chart:{type:"bar",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},plotOptions:{bar:{borderRadius:8,columnWidth:"60%",distributed:!0}},series:[{name:"Conversions",data:seriesData}],xaxis:{categories:categories,labels:{style:{colors:colors.textColor},rotate:-45,trim:!1}},yaxis:{labels:{style:{colors:colors.textColor}}},colors:dynamicColors,grid:{borderColor:colors.gridColor},legend:{show:!1},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};barChart&&barChart.destroy(),barChart=new ApexCharts(document.querySelector("#conversionBar"),barOptions),barChart.render()}).catch(error=>{const barOptions={chart:{type:"bar",height:320,toolbar:{show:!1},background:colors.bgColor,fontFamily:"Inter"},plotOptions:{bar:{borderRadius:8,columnWidth:"60%",distributed:!0}},series:[{name:"Conversions",data:[5,3,2]}],xaxis:{categories:["WhatsApp","Telegram","Email"],labels:{style:{colors:colors.textColor}}},yaxis:{labels:{style:{colors:colors.textColor}}},colors:["#22c55e","#3b82f6","#f59e0b"],grid:{borderColor:colors.gridColor},legend:{show:!1},tooltip:{theme:html.classList.contains("dark")?"dark":"light"}};barChart&&barChart.destroy(),barChart=new ApexCharts(document.querySelector("#conversionBar"),barOptions),barChart.render()})}function initCharts(){createLineChart(30),createDonutChart(),createAreaChart(),createBarChart()}function updateChartThemes(){setTimeout(()=>{initCharts()},100)}document.addEventListener("DOMContentLoaded",initCharts),document.getElementById("rangeSelect").addEventListener("change",e=>{const days=parseInt(e.target.value,10);createLineChart(days)}),document.addEventListener("DOMContentLoaded",(function(){function hideAllSkeletons(){const kpiSkeleton=document.querySelectorAll(".kpi-cards-skeleton"),kpiContent=document.querySelectorAll(".kpi-cards-content");kpiSkeleton.forEach(skeleton=>skeleton.classList.add("hidden")),kpiContent.forEach(content=>content.classList.remove("hidden"));const chartsSkeleton=document.querySelectorAll(".charts-skeleton"),chartsContent=document.querySelectorAll(".charts-content");chartsSkeleton.forEach(skeleton=>skeleton.classList.add("hidden")),chartsContent.forEach(content=>content.classList.remove("hidden"));const secondChartsSkeleton=document.querySelectorAll(".second-charts-skeleton"),secondChartsContent=document.querySelectorAll(".second-charts-content");secondChartsSkeleton.forEach(skeleton=>skeleton.classList.add("hidden")),secondChartsContent.forEach(content=>content.classList.remove("hidden"));const tableSkeleton=document.querySelector(".table-skeleton"),tableContent=document.querySelector(".table-content");tableSkeleton&&tableContent&&(tableSkeleton.classList.add("hidden"),tableContent.classList.remove("hidden"))}const chartContainers=["#campaignLine","#channelDonut","#contactsArea","#conversionBar"];let loadedCharts=0;chartContainers.forEach(selector=>{const container=document.querySelector(selector);if(container){const observer=new MutationObserver(mutations=>{mutations.forEach(mutation=>{"childList"===mutation.type&&mutation.addedNodes.length>0&&(loadedCharts++,loadedCharts>=chartContainers.length&&setTimeout(hideAllSkeletons,200),observer.disconnect())})});observer.observe(container,{childList:!0,subtree:!0})}}),setTimeout(hideAllSkeletons,2e3)}));